/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.launchables;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.zeroturnaround.eclipse.config.ui.launchables.ILaunchablesProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.RebelLaunchablesTable;

public class LaunchablesColumnLabelProvider<L, C>
extends ColumnLabelProvider {
    private final ILaunchablesProvider<L, C> provider;

    public LaunchablesColumnLabelProvider(ILaunchablesProvider<L, C> provider) {
        this.provider = provider;
    }

    public String getText(Object element) {
        if (element == RebelLaunchablesTable.NO_LAUNCHABLES) {
            return this.getNoLaunchablesText();
        }
        if (this.provider.isLaunchableType(element)) {
            return this.provider.getLabel(element);
        }
        return element == null ? "" : element.toString();
    }

    public Image getImage(Object element) {
        if (this.provider.isLaunchableType(element)) {
            return this.provider.getImage(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element == RebelLaunchablesTable.NO_LAUNCHABLES) {
            return SWTResourceManager.getColor(16);
        }
        if (!this.provider.isLaunchableType(element) || this.provider.getAdapter(element) == null) {
            return SWTResourceManager.getColor(16);
        }
        return null;
    }

    protected String getNoLaunchablesText() {
        return "Click Add... to configure servers";
    }

    public String getToolTipText(Object element) {
        return "Right click to see more options";
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }
}

