/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.launchables;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.zeroturnaround.eclipse.config.ui.launchables.ILaunchablesProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.RebelLaunchablesTable;

public class LaunchablesContentProvider<L, C>
implements ITreeContentProvider {
    public static final Object ROOT = new Object();
    private final ILaunchablesProvider<L, C> provider;
    private L[] launchables;

    public LaunchablesContentProvider(ILaunchablesProvider<L, C> provider) {
        this.provider = provider;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element == ROOT) {
            return true;
        }
        if (this.provider.isLaunchableType(element)) {
            Object launchable = element;
            return this.provider.hasChildren(launchable);
        }
        return false;
    }

    public Object[] getChildren(Object element) {
        if (element == ROOT) {
            Object[] objectArray;
            if (this.launchables.length > 0) {
                objectArray = this.launchables;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = RebelLaunchablesTable.NO_LAUNCHABLES;
            }
            return objectArray;
        }
        if (this.provider.isLaunchableType(element)) {
            Object launchable = element;
            return this.provider.getChildren(launchable);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (this.provider.isLaunchableType(element)) {
            Object launchable = element;
            return this.provider.getParent(launchable);
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.launchables = this.provider.getLaunchables();
        }
    }

    public void dispose() {
    }
}

