/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.launchables;

import java.util.IdentityHashMap;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.config.components.ICheckStateAdapter;
import org.zeroturnaround.eclipse.config.components.ZTCheckboxTreeViewer;
import org.zeroturnaround.eclipse.config.ui.launchables.ILaunchablesProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.LaunchablesCheckStateAdapter;
import org.zeroturnaround.eclipse.config.ui.launchables.LaunchablesColumnLabelProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.LaunchablesContentProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.NoAdapter;
import org.zeroturnaround.eclipse.jrebel.events.JRebelEnablementChangedEvent;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeAdapter;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeListener;
import org.zeroturnaround.eclipse.launching.IRebelLaunchable;
import org.zeroturnaround.eclipse.util.EclipseUtil;

public abstract class RebelLaunchablesTable<L, C>
extends Composite {
    public static final Object NO_LAUNCHABLES = new Object();
    protected final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private final IdentityHashMap<L, IRebelLaunchable<L, C>> adapters = new IdentityHashMap();
    private final JRebelServiceChangeListener jrebelServiceListener;
    protected final ILaunchablesProvider<L, C> provider;
    protected ZTCheckboxTreeViewer treeViewer;
    protected ICheckStateAdapter checkStateAdapter;

    public RebelLaunchablesTable(Composite parent, int style, final ILaunchablesProvider<L, C> provider) {
        super(parent, style);
        this.provider = provider;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RebelLaunchablesTable.this.toolkit.dispose();
                RebelPlugin.getJRebelService().removeListener(RebelLaunchablesTable.this.jrebelServiceListener);
            }
        });
        this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 15;
        this.setLayout((Layout)layout);
        this.createTable();
        this.createButtonsContainer();
        this.createAdditionalComponents();
        this.jrebelServiceListener = new JRebelServiceChangeAdapter(){

            @Override
            public void rebelEnabledChanged(JRebelEnablementChangedEvent event) {
                if (event.source == RebelLaunchablesTable.this) {
                    return;
                }
                if (provider.isLaunchableType(event.launchable)) {
                    EclipseUtil.runInUiThread(() -> RebelLaunchablesTable.this.treeViewer.refresh(jRebelEnablementChangedEvent.launchable, true));
                }
            }
        };
        RebelPlugin.getJRebelService().addListener(this.jrebelServiceListener);
    }

    public final void addDisposeListener(DisposeListener listener) {
        super.addDisposeListener(listener);
    }

    public final void setLayout(Layout layout) {
        super.setLayout(layout);
    }

    public final void setLayoutData(Object layoutData) {
        super.setLayoutData(layoutData);
    }

    private void createTable() {
        Composite treeContainer = new Composite((Composite)this, 0);
        GridData gdata = new GridData(4, 4, true, true, 1, 1);
        gdata.minimumHeight = 80;
        treeContainer.setLayoutData((Object)gdata);
        this.toolkit.adapt(treeContainer);
        this.toolkit.paintBordersFor(treeContainer);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        treeContainer.setLayout((Layout)columnLayout);
        this.treeViewer = new ZTCheckboxTreeViewer(treeContainer, 2080);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.toolkit.paintBordersFor((Composite)tree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        TreeViewerColumn col1 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeColumn colLaunchable = col1.getColumn();
        columnLayout.setColumnData((Widget)colLaunchable, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        colLaunchable.setText("Servers");
        LaunchablesColumnLabelProvider<L, C> labelProvider = this.createMainColumnLabelProvider();
        col1.setLabelProvider(labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new LaunchablesContentProvider<L, C>(this.provider));
        this.checkStateAdapter = this.createCheckStateAdapter();
        this.treeViewer.setCheckStateAdapter(this.checkStateAdapter);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (RebelLaunchablesTable.this.provider.isLaunchableType(sel.getFirstElement())) {
                    RebelLaunchablesTable.this.provider.openLaunchableUI(RebelLaunchablesTable.this, sel.getFirstElement());
                }
            }
        });
        this.createMenu(tree);
        this.setInput(LaunchablesContentProvider.ROOT);
    }

    protected LaunchablesColumnLabelProvider<L, C> createMainColumnLabelProvider() {
        return new LaunchablesColumnLabelProvider<L, C>(this.provider);
    }

    protected LaunchablesCheckStateAdapter<L, C> createCheckStateAdapter() {
        return new LaunchablesCheckStateAdapter<L, C>(this.provider, this);
    }

    protected void createMenu(Tree tree) {
    }

    private void createButtonsContainer() {
        Composite buttonsContainer = new Composite((Composite)this, 0);
        buttonsContainer.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.toolkit.adapt(buttonsContainer);
        this.toolkit.paintBordersFor(buttonsContainer);
        buttonsContainer.setLayout((Layout)new GridLayout(1, false));
        this.createButtons(buttonsContainer);
    }

    protected abstract void createButtons(Composite var1);

    protected void createAdditionalComponents() {
    }

    public IRebelLaunchable<L, C> getAdapter(L launchable) {
        IRebelLaunchable<L, C> adapter = this.adapters.get(launchable);
        if (adapter == null) {
            adapter = this.provider.getAdapter(launchable);
            if (adapter == null) {
                this.adapters.put(launchable, NoAdapter.getInstance());
            } else {
                this.adapters.put(launchable, adapter);
            }
        }
        return adapter == NoAdapter.getInstance() ? null : adapter;
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
        if (input != null) {
            this.treeViewer.expandAll();
        }
    }
}

