/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.common.util.LicenseUtils;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.IPanel;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelConfirmation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelEmailAlreadyUsed;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelLicenseActivation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelOfflineActivation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelOnlineActivation;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.LicensingMessage;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.metrics.NPSSender;
import org.zeroturnaround.jrebel.ide.common.notifications.LicenseNotifier;
import org.zeroturnaround.jrebel.ide.common.ui.activation.ActivationPanelMessage;
import org.zeroturnaround.jrebel.ide.common.ui.activation.LicenseChangeTracker;

public class ActivationDialogNew
extends Dialog {
    private static final String HAVE_LICENSE_LABEL = "Team evaluation or commercial license";
    private static final String TRY_JREBEL_LABEL = "Individual trial";
    private static final Pattern PATTERN_EMAIL_ADDRESS_ALREADY_USED = Pattern.compile("Email address '(.*)' has already been used");
    private final JRebelConfiguration configuration = JRebelConfiguration.getDefault();
    public static final int buttonAID = 1025;
    public static final int buttonBID = 1026;
    public static final int buttonCID = 1027;
    private static final Log log = Log.getInstance(ActivationDialogNew.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(ActivationDialogNew.class);
    private Button[] dialogButtons;
    private TabFolder tabFolder;
    private final List<TabItem> tabItems = new ArrayList<TabItem>();
    private final List<PanelAbstract> tabPanels = new ArrayList<PanelAbstract>();
    private DialogController controller;
    private LicensingStatus licensingStatus;
    private final LicenseChangeTracker licenseTracker;

    public ActivationDialogNew(Shell parentShell, LicensingStatus licensingStatus) {
        super(parentShell);
        log.trace("ActivationDialogNew.ActivationDialogNew()");
        this.licensingStatus = licensingStatus;
        this.licenseTracker = new LicenseChangeTracker(licensingStatus);
        this.trace(licensingStatus);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        log.trace("ActivationDialogNew.configureShell()");
        newShell.setImage(RebelImage.JREBEL.getImage());
        newShell.setText("JRebel Activation Details");
    }

    protected Control createDialogArea(Composite parent) {
        log.trace("ActivationDialogNew.createDialogArea() {}", (Object)parent);
        Composite area = (Composite)super.createDialogArea(parent);
        this.controller = new DialogController(this.getShell());
        this.controller.setDialog(this);
        this.configuration.init();
        this.tabFolder = new TabFolder(area, 0);
        this.createInitialTabs();
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActivationDialogNew.this.updateButtonLabelsAndVisibility();
            }
        });
        return area;
    }

    public int open() {
        LicenseNotifier.getInstance().suspendNewNotifications();
        return super.open();
    }

    public boolean close() {
        log.trace("ActivationDialogNew.close()");
        LicenseNotifier.getInstance().resumeNewNotifications();
        if (this.controller != null) {
            this.controller.onDialogClosed();
        } else {
            log.error("dialog controller is null");
        }
        for (PanelAbstract tab : this.tabPanels) {
            try {
                tab.onClose();
            }
            catch (Exception e) {
                log.debug("Tab close error: {}", (Object)tab, (Object)e);
            }
        }
        return super.close();
    }

    private void createInitialTabs() {
        if ((this.licensingStatus.isExpired() || this.licensingStatus.isValid()) && !this.licensingStatus.isEvaluation()) {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
        } else if (this.licensingStatus.isValid() && this.licensingStatus.isEvaluation()) {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
            this.addTab(TRY_JREBEL_LABEL, new PanelConfirmation(this.controller, this.licensingStatus));
        } else if (this.licensingStatus.isActivationPending()) {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
            this.addTab(TRY_JREBEL_LABEL, new PanelConfirmation(this.controller, this.licensingStatus));
        } else if (Watcher.getInstance().getLicensing().isTrialFootprintDetected(false) && this.isTrialLicenseExpired()) {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
            this.addTab(TRY_JREBEL_LABEL, new PanelConfirmation(this.controller, new LicensingStatus(null, new LicensingMessage("Trial License expired."))));
        } else if (this.controller.isTrialRegistrationAvailable()) {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
            this.addTab(TRY_JREBEL_LABEL, new PanelOnlineActivation(this.controller));
        } else {
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
            this.addTab(TRY_JREBEL_LABEL, new PanelOfflineActivation(this.controller));
        }
    }

    private boolean isTrialLicenseExpired() {
        Calendar detectedTrialUntil = LicenseUtils.getDetectedTrialEndDate();
        return detectedTrialUntil != null && detectedTrialUntil.before(Calendar.getInstance());
    }

    private void addTab(String label, PanelAbstract panel) {
        panel.setNameForPanel(label);
        TabItem newTabItem = new TabItem(this.tabFolder, 0);
        panel.setDialog(this);
        newTabItem.setText(panel.getNameForPanel());
        newTabItem.setControl(panel.getControl((Composite)this.tabFolder));
        this.tabItems.add(newTabItem);
        this.tabPanels.add(panel);
    }

    private void updateButtonLabelsAndVisibility() {
        if (this.dialogButtons == null) {
            return;
        }
        ButtonData[] data = this.getCurrentTabPanel().getButtonData();
        Button[] buttons = this.dialogButtons;
        int i = 0;
        while (i < buttons.length) {
            Button theButton = buttons[i];
            if (data != null && data.length > i) {
                theButton.setText(data[i].getLabel());
                theButton.setEnabled(data[i].isEnabled());
                theButton.setVisible(true);
            } else {
                theButton.setVisible(false);
            }
            ++i;
        }
    }

    public int getSelectedTabIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public void switchToEmailAlreadyUsedPanel(String email) {
        this.switchToPanel(new PanelEmailAlreadyUsed(this.controller, this.licensingStatus, email), true);
    }

    public void switchToConfirmation() {
        log.trace("ActivationDialogNew.switchToConfirmation()");
        log.trace("is trial " + this.licensingStatus.isEvaluation());
        log.trace("number of tabs " + this.tabFolder.getItemCount());
        this.switchToPanel(new PanelConfirmation(this.controller, this.licensingStatus), true);
        if (this.tabFolder.getItemCount() == 1 && this.licensingStatus.isEvaluation()) {
            this.tabPanels.get(0).setNameForPanel(TRY_JREBEL_LABEL);
            this.addTab(HAVE_LICENSE_LABEL, new PanelLicenseActivation(this.controller, this.licensingStatus));
        }
    }

    private void switchToPanel(PanelAbstract newTab, boolean findPanelUnderActivation) {
        newTab.setNameForPanel(this.getCurrentTabPanel().getNameForPanel());
        newTab.setDialog(this);
        int index = -1;
        if (findPanelUnderActivation) {
            int cntr = 0;
            for (PanelAbstract p : this.tabPanels) {
                if (p.isUnderActivation()) {
                    index = cntr;
                    p.resetUnderActivationFlag();
                    break;
                }
                ++cntr;
            }
        }
        int indexOfTabWithSuchName = -1;
        int cntr = 0;
        for (PanelAbstract p : this.tabPanels) {
            if (p.getNameForPanel().equals(newTab.getNameForPanel())) {
                indexOfTabWithSuchName = cntr;
                break;
            }
            ++cntr;
        }
        index = indexOfTabWithSuchName >= 0 ? indexOfTabWithSuchName : (index < 0 ? this.getSelectedTabIndex() : index);
        this.tabPanels.get(index).onClose();
        TabItem tab = this.tabItems.get(index);
        this.tabPanels.set(index, newTab);
        tab.setText(newTab.getNameForPanel());
        tab.setControl(newTab.getControl((Composite)this.tabFolder));
        this.updateButtonLabelsAndVisibility();
    }

    public void switchToTab(int i) {
        this.tabFolder.setSelection(i);
        this.updateButtonLabelsAndVisibility();
    }

    @NotNull
    private IPanel getCurrentTabPanel() {
        IPanel ret;
        int currentIndex = this.tabFolder.getSelectionIndex();
        if ((currentIndex == 0 || currentIndex == 1) && (ret = (IPanel)this.tabPanels.get(currentIndex)) != null) {
            log.trace("ActivationDialogNew.getCurrentTabPanel() {}", (Object)ret.getClass().getSimpleName());
            return ret;
        }
        throw new IllegalStateException("Invalid current index " + currentIndex);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        log.info("creating buttons for dialog: {}", (Object)parent);
        GridLayout newLay = new GridLayout();
        GridLayout oldLay = (GridLayout)parent.getLayout();
        newLay.numColumns = oldLay.numColumns;
        newLay.makeColumnsEqualWidth = false;
        newLay.marginWidth = oldLay.marginWidth;
        newLay.marginHeight = oldLay.marginHeight;
        newLay.horizontalSpacing = oldLay.horizontalSpacing;
        newLay.verticalSpacing = oldLay.verticalSpacing;
        parent.setLayout((Layout)newLay);
        Button buttonB = this.createButton(parent, 1026, "Open JRebel Configuration", false);
        Button buttonA = this.createButton(parent, 1025, "Open JRebel Configuration", true);
        this.dialogButtons = new Button[]{buttonA, buttonB};
        this.updateButtonLabelsAndVisibility();
    }

    protected void buttonPressed(int buttonId) {
        log.trace("ActivationDialogNew.buttonPressed() " + buttonId);
        this.getCurrentTabPanel().onButtonPressed(buttonId);
    }

    public void setLicensingStatus(LicensingStatus licensingStatus) {
        log.trace("ActivationDialogNew.setLicensingStatus() {}", (Object)licensingStatus);
        if (this.getShell() == null) {
            log.debug("ActivationDialog already closed");
            return;
        }
        this.licenseTracker.compareToInitialLicenseStatus(licensingStatus);
        LicensingStatus previous = this.licensingStatus;
        this.licensingStatus = licensingStatus;
        this.trace(licensingStatus);
        Runnable r = () -> {
            int currentIndex = this.getSelectedTabIndex();
            IPanel panelUnderActivation = null;
            try {
                for (PanelAbstract panel : this.tabPanels) {
                    if (!panel.isUnderActivation()) continue;
                    panelUnderActivation = panel;
                    break;
                }
                if (panelUnderActivation == null) {
                    panelUnderActivation = this.getCurrentTabPanel();
                }
                if (licensingStatus.hasError() && !licensingStatus.isActivationPending()) {
                    consoleLog.error(licensingStatus.errorMessage.getText());
                    Matcher m = PATTERN_EMAIL_ADDRESS_ALREADY_USED.matcher(licensingStatus.errorMessage.getText());
                    if (licensingStatus.errorMessage.getText().contains("\"status\":-4") && m.find()) {
                        this.switchToEmailAlreadyUsedPanel(m.group(1));
                    } else {
                        panelUnderActivation.showMessage(new ActivationPanelMessage(licensingStatus));
                    }
                } else if (licensingStatus.isValid()) {
                    log.trace(" ********* got valid license");
                    NPSSender.saveFirstActivationTime((long)System.currentTimeMillis());
                    panelUnderActivation.clearMessage();
                    if (!previous.isLoading()) {
                        if (licensingStatus.isEvaluation()) {
                            this.setSelectedTabForIndex(this.tabItems.size() - 1);
                        } else if (this.tabItems.size() > 1) {
                            this.disableTab(1);
                            this.setSelectedTabForIndex(0);
                        }
                        this.switchToConfirmation();
                    }
                } else if (licensingStatus.isActivationPending()) {
                    log.trace(" ********* got team url. seat user email verification pending.");
                    NPSSender.saveFirstActivationTime((long)System.currentTimeMillis());
                    panelUnderActivation.clearMessage();
                    if (!previous.isLoading()) {
                        if (currentIndex == 0) {
                            this.setSelectedTabForIndex(0);
                            this.disableTab(1);
                        } else if (currentIndex == 1) {
                            this.setSelectedTabForIndex(1);
                            this.disableTab(0);
                        } else {
                            log.debug("Invalid index. Only 0 and 1 are supported.");
                        }
                        this.switchToConfirmation();
                    }
                }
            }
            finally {
                if (panelUnderActivation instanceof PanelAbstract) {
                    ((PanelAbstract)panelUnderActivation).resetUnderActivationFlag();
                }
            }
        };
        EclipseUtil.runInUiThread(r);
    }

    protected void setSelectedTabForIndex(int index) {
        this.tabFolder.setSelection(index);
    }

    protected void disableTab(int index) {
        this.tabFolder.getItem(index).setControl(null);
    }

    public final void trace(LicensingStatus licensingStatus) {
        LicenseUtils.traceLog((LicensingStatus)licensingStatus);
    }

    public void enableActivateButton(boolean state) {
        if (this.dialogButtons != null) {
            this.dialogButtons[0].setEnabled(state);
        }
    }

    public LicenseChangeTracker getLicenseTracker() {
        return this.licenseTracker;
    }
}

