/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.ui.AdvancedPage;
import org.zeroturnaround.eclipse.config.ui.newactivation.ActivationDialogNew;
import org.zeroturnaround.eclipse.config.ui.newactivation.IPanel;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelConfirmation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelLicenseActivation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelOfflineActivation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelOnlineActivation;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelTrialExpired;
import org.zeroturnaround.eclipse.notifications.controllers.JRebelActivationDialogControllerCommon;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.TrialRegistrationFormData;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.metrics.MetricsConsent;
import org.zeroturnaround.jrebel.ide.common.startup.StartupScenarioPreferences;
import org.zeroturnaround.jrebel.ide.common.ui.activation.ActivationPanelMessage;
import org.zeroturnaround.jrebel.ide.common.ui.activation.JRebelLicenseActivationPanel;
import org.zeroturnaround.jrebel.ide.common.ui.activation.JRebelTrialOfflineActivationPanel;
import org.zeroturnaround.jrebel.ide.common.ui.activation.JRebelTrialOnlineActivationPanel;
import org.zeroturnaround.jrebel.ide.common.utils.WebLink;

public class DialogController
extends JRebelActivationDialogControllerCommon
implements Watcher.Listener {
    private static final Log log = Log.getInstance(DialogController.class);
    final Shell swtShell;
    private ActivationDialogNew dialog;

    public DialogController(Shell swtShell) {
        this.swtShell = swtShell;
        Watcher.getInstance().listenForLicenseChange((Watcher.Listener)this);
    }

    public void setDialog(ActivationDialogNew dialog) {
        this.dialog = dialog;
    }

    public void onButtonOpenConfigCenter(PanelConfirmation source) {
        StartupScenarioPreferences.saveIdeStartupSettingsVisitedWhileActivated();
        EclipseUtil.runInUiThread(() -> JRebelConfigCenter.openProjects());
    }

    public void onButtonStartTrial_async(PanelOnlineActivation panel, TrialRegistrationFormData formData) {
        log.trace("DialogController.onButtonStartTrial_async() " + formData.toString());
        panel.showMessage(new ActivationPanelMessage("JRebel activation in process", ActivationPanelMessage.Type.IN_PROGRESS));
        Runnable r = () -> {
            try {
                LicensingStatus activationInfo;
                LicensingStatus activationInfoTmp = activationInfo = this.activateForFormData(formData);
                this.runInUI(() -> {
                    boolean bl = this.handleActivationResult(activationInfoTmp, panel, this.dialog);
                });
            }
            catch (Exception e) {
                log.error("Failed activating with trial", (Throwable)e);
            }
        };
        this.runInBackground(r, false, "Activating JRebel", "Running trial activation");
    }

    public void onUserOpensLicenseAgreement(JRebelTrialOnlineActivationPanel source, String defaultLink) {
        BrowserUtil.silentOpenLink((String)defaultLink);
    }

    public void onLicenseTextChanged(JRebelTrialOfflineActivationPanel panel, String text) {
    }

    public void onButtonActivate(PanelOfflineActivation panel, String text) {
        panel.showMessage(new ActivationPanelMessage("JRebel activation in process", ActivationPanelMessage.Type.IN_PROGRESS));
        Runnable r = () -> {
            LicensingStatus activationInfo = null;
            try {
                LicensingStatus activationInfoTmp = activationInfo = this.activateForPasted(text);
                this.runInUI(() -> {
                    boolean bl = this.handleActivationResult(activationInfoTmp, panel, this.dialog);
                });
            }
            catch (Exception e) {
                log.error("Failed to activate", (Throwable)e);
            }
        };
        this.runInBackground(r, false, "Activating JRebel", "Running trial activation");
    }

    public void onButtonCancel(PanelLicenseActivation panel) {
        this.dialog.close();
    }

    public void onButtonActivate_async(PanelLicenseActivation panel, JRebelLicenseActivationPanel.Data data) {
        log.trace(" ********* data mode " + data.getMode());
        panel.showMessage(new ActivationPanelMessage("JRebel activation in process", ActivationPanelMessage.Type.IN_PROGRESS));
        Runnable r = () -> {
            LicensingStatus activationInfo = null;
            switch (data.getMode()) {
                case ACTIVATION_CODE: {
                    activationInfo = this.activateForPasted(data.getActivationCodeText());
                    break;
                }
                case LICENSE_FILE: {
                    activationInfo = this.activateForFile(data.getLicenseFile());
                    break;
                }
                case LICENSE_SERVER: {
                    activationInfo = this.activateForLicenseServer(data.getLicenseServerAddress(), data.getEmail());
                    break;
                }
            }
            LicensingStatus activationInfoTmp = activationInfo;
            this.runInBackground(() -> {
                boolean bl = this.handleActivationResult(activationInfoTmp, panel, this.dialog);
            });
        };
        this.runInBackground(r);
    }

    public void onButtonEnterALicense(PanelTrialExpired panelTrialExpired) {
        this.dialog.switchToTab(0);
    }

    public void onButtonExtendTrial(IPanel panelTrialExpired, LicensingStatus licensingStatus) {
        BrowserUtil.silentOpenLink((String)WebLink.getJrebelExtendTrialLink((LicensingStatus)licensingStatus));
    }

    protected void handleLicensingStatus(LicensingStatus licensingStatus) {
        log.info("licensingStatus: {} {}", (Object)licensingStatus.hasError(), (Object)licensingStatus.errorMessage);
        this.runInBackground(() -> this.dialog.setLicensingStatus(licensingStatus));
    }

    public void licenseStatusChanged(LicensingStatus status) {
        this.handleLicensingStatus(status);
    }

    public void onDialogClosed() {
        Watcher.getInstance().removeLicenseChangeListener((Watcher.Listener)this);
        MetricsConsent.getInstance().showDialogIfRequired((MetricsConsent.DialogResultCallback)new AdvancedPage.ConsentButtonsStateUpdater());
    }
}

