/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.ui.RebelImage;

public final class FieldProgressMessage
extends Composite {
    private Label image;
    private Link message;
    private final Composite container;

    public FieldProgressMessage(Composite container, int hCols, Widget parent) {
        super(container, 0);
        this.container = container;
        GridLayout containerLayout = new GridLayout(2, false);
        this.setLayout((Layout)containerLayout);
        final GridData layoutData = new GridData(4, 4, true, false, hCols, 1);
        this.setLayoutData(layoutData);
        this.image = this.createImage(this, RebelImage.MESSAGE_INFO.getImage());
        this.message = new Link((Composite)this, 64);
        this.message.addListener(13, event -> BrowserUtil.silentOpenLink((String)event.text));
        FontData[] fD = this.message.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() * 120 / 100);
        this.message.setFont(new Font((Device)container.getDisplay(), fD[0]));
        this.message.setForeground(container.getDisplay().getSystemColor(9));
        this.message.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                layoutData.widthHint = FieldProgressMessage.this.getSize().x;
            }
        });
    }

    private Label createImage(Composite container, Image icon) {
        Label image = new Label(container, 0);
        image.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        image.setImage(icon);
        image.pack();
        return image;
    }

    public FieldProgressMessage setText(String text) {
        this.message.setText(text);
        this.message.getParent().getParent().layout(true, true);
        this.message.getParent().getParent().pack();
        return this;
    }

    public String getText() {
        return this.message.getText();
    }

    public FieldProgressMessage setIcon(Image icon) {
        this.image.setImage(icon);
        this.image.pack();
        this.image.getParent().layout();
        return this;
    }

    public FieldProgressMessage setTextColor(int systemColorIndex) {
        this.message.setForeground(this.container.getDisplay().getSystemColor(systemColorIndex));
        return this;
    }

    public void show() {
        this.getParent().getParent().pack();
        this.setVisible(true);
    }

    public void hide() {
        this.getParent().getParent().pack();
        this.setVisible(false);
    }
}

