/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.eclipse.config.ui.newactivation.validator.IValidator;
import org.zeroturnaround.eclipse.ui.RebelImage;

public class FieldTextWithValidator {
    private Label image;
    private Text text;
    private final IValidator validator;

    public FieldTextWithValidator(final Composite container, int style, String labelText, String content, IValidator validator, final Runnable textModifyListener) {
        this.validator = validator;
        Label label = new Label(container, 64);
        label.setText(labelText);
        this.text = new Text(container, 2052);
        if ("linux".equals(Platform.getOS())) {
            this.text.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 16) {
                        Control[] control = container.getTabList();
                        int thePosition = -1;
                        int pos = 0;
                        while (pos < control.length) {
                            if (control[pos] == FieldTextWithValidator.this.text) {
                                thePosition = pos;
                                break;
                            }
                            ++pos;
                        }
                        if (thePosition >= 0) {
                            if (++thePosition >= control.length) {
                                thePosition = 0;
                            }
                            control[thePosition].setFocus();
                        }
                    }
                }
            });
        }
        this.text.setText(content);
        GridData textsLayoutData = new GridData(4, 0x1000000, false, false);
        textsLayoutData.widthHint = 250;
        this.text.setLayoutData((Object)textsLayoutData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                textModifyListener.run();
                FieldTextWithValidator.this.revalidate();
            }
        });
        this.image = PanelAbstract.createImage(container, null);
        this.image.setLayoutData((Object)new GridData(1, 128, false, false));
    }

    public Composite getMainComponentParent() {
        return this.text.getParent();
    }

    public Control getMainComponent() {
        return this.text;
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    public String getText() {
        return this.text.getText();
    }

    public void revalidate() {
        if (this.isDataValid()) {
            this.setValid();
        } else {
            this.setInvalid();
        }
    }

    public void setInvalid() {
        this.image.setImage(RebelImage.FIELD_ERROR.getImage());
        this.image.pack();
    }

    public void setValid() {
        this.image.setImage(RebelImage.FIELD_OK.getImage());
        this.image.pack();
    }

    public boolean isDataValid() {
        return this.validator.isValid(this.text.getText());
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }
}

