/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.RebelLog;
import org.zeroturnaround.eclipse.config.ui.newactivation.ActivationDialogNew;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.FieldProgressMessage;
import org.zeroturnaround.eclipse.config.ui.newactivation.IPanel;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.ui.activation.ActivationPanelMessage;
import org.zeroturnaround.jrebel.ide.common.ui.activation.Messages;
import org.zeroturnaround.jrebel.ide.common.utils.WebLink;

public abstract class PanelAbstract
implements IPanel {
    protected static final String LABEL_BUTTON_ACTIVATE = "Activate JRebel";
    private static final Log log = Log.getInstance(PanelAbstract.class);
    protected volatile boolean underActivation;
    ActivationDialogNew dialog;
    final DialogController controller;
    private String nameForPanel;
    protected FieldProgressMessage progressLabel;
    private String lastMessage = "";

    public PanelAbstract(DialogController controller) {
        this.controller = controller;
    }

    boolean isUnderActivation() {
        return this.underActivation;
    }

    void resetUnderActivationFlag() {
        this.underActivation = false;
    }

    public Link buildLink(Composite container, String text, String url) {
        Link link = new Link(container, 0);
        link.setText("<A>" + text + "</A>");
        link.addListener(13, event -> BrowserUtil.silentOpenLink((String)url));
        return link;
    }

    public void setControlHspan(Control label, int hspan) {
        label.setLayoutData((Object)new GridData(4, 4, false, false, hspan, 1));
    }

    public GridData buildGridDataWithIndent(int horizontalIndent, int verticalIndent) {
        GridData ret = new GridData(768);
        ret.horizontalIndent = horizontalIndent;
        ret.verticalIndent = verticalIndent;
        return ret;
    }

    public GridData buildGridDataWithIndent(int horizontalIndent, int verticalIndent, int hSpan, int gridDataStyle) {
        GridData ret = new GridData(gridDataStyle);
        ret.horizontalIndent = horizontalIndent;
        ret.verticalIndent = verticalIndent;
        ret.horizontalSpan = hSpan;
        return ret;
    }

    public GridData buildGridDataWithIndent(int horizontalIndent, int verticalIndent, int hSpan) {
        return this.buildGridDataWithIndent(horizontalIndent, verticalIndent, hSpan, 768);
    }

    protected void createNewLine(Composite container, int hSpan) {
        Label newline = new Label(container, 0);
        newline.setText("   ");
        newline.setLayoutData((Object)new GridData(4, 4, false, false, hSpan, 1));
    }

    protected static Label createImage(Composite container, Image icon) {
        Label image = new Label(container, 0);
        image.setImage(icon);
        return image;
    }

    protected FieldProgressMessage createProgressLabel(Composite container, int hCols, Widget parent) {
        return new FieldProgressMessage(container, hCols, parent);
    }

    protected Label createLabel(Composite container, String text, int fontHeight, int sytemColorIndex) {
        return this.createLabel(container, text, fontHeight, sytemColorIndex, 0);
    }

    protected Label createLabel(Composite container, String text, int fontHeight, int sytemColorIndex, int fontStyle) {
        Label ret = new Label(container, 0);
        if (text.contains("&")) {
            text = text.replace("&", "&&");
        }
        ret.setText(text);
        FontData[] fD = ret.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() * fontHeight / 100);
        fD[0].setStyle(fontStyle);
        Font f = new Font((Device)container.getDisplay(), fD[0]);
        ret.setFont(f);
        ret.addDisposeListener(e -> f.dispose());
        if (sytemColorIndex != -1) {
            ret.setForeground(container.getDisplay().getSystemColor(sytemColorIndex));
        }
        return ret;
    }

    protected Label createLabel(Composite container, String text, int fontHeight, Color color, int fontStyle) {
        Label ret = new Label(container, 0);
        if (text.contains("&")) {
            text = text.replace("&", "&&");
        }
        ret.setText(text);
        FontData[] fD = ret.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() * fontHeight / 100);
        fD[0].setStyle(fontStyle);
        Font f = new Font((Device)container.getDisplay(), fD[0]);
        ret.setFont(f);
        ret.addDisposeListener(e -> f.dispose());
        ret.setForeground(color);
        return ret;
    }

    protected Text createMultilineText(Composite container, Runnable modifyListener) {
        Text text = new Text(container, 2626);
        GridData liceseCodeGridData = new GridData(768);
        liceseCodeGridData.heightHint = text.getLineHeight() * 8;
        this.setFixedWidthLayout((Control)text, liceseCodeGridData);
        if (modifyListener != null) {
            text.addModifyListener(e -> modifyListener.run());
        }
        return text;
    }

    protected void setFixedWidthLayout(Control composite, final GridData gridData) {
        composite.setLayoutData((Object)gridData);
        final int width = composite.getSize().x;
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                gridData.widthHint = width;
            }
        });
    }

    protected Button createTosCheckbox(final Composite container, int hCols, final Runnable onSelectionChanged) {
        Composite wrapper = new Composite(container, 0);
        GridLayout containerLayout = new GridLayout(3, false);
        containerLayout.horizontalSpacing = 0;
        wrapper.setLayout((Layout)containerLayout);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, true, hCols, 1));
        final Button checkboxUseIDEProxySettings = new Button(wrapper, 32);
        if ("linux".equals(Platform.getOS())) {
            checkboxUseIDEProxySettings.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 16) {
                        Control[] control = container.getTabList();
                        int thePosition = -1;
                        int pos = 0;
                        while (pos < control.length) {
                            if (control[pos] == checkboxUseIDEProxySettings.getParent()) {
                                thePosition = pos;
                                break;
                            }
                            ++pos;
                        }
                        if (thePosition >= 0) {
                            if (++thePosition >= control.length) {
                                thePosition = 0;
                            }
                            control[thePosition].setFocus();
                        }
                    }
                }
            });
        }
        checkboxUseIDEProxySettings.setText("I agree with the terms && conditions of ");
        checkboxUseIDEProxySettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        Link url = this.buildLink(wrapper, "the License Agreement", WebLink.JREBEL_EULA);
        GridData urlData = new GridData(16384, 0x1000000, true, false, 1, 1);
        urlData.horizontalIndent = 0;
        url.setLayoutData((Object)urlData);
        new Label(wrapper, 0).setText("    ");
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (onSelectionChanged != null) {
                    onSelectionChanged.run();
                }
            }
        };
        checkboxUseIDEProxySettings.addSelectionListener((SelectionListener)l);
        return checkboxUseIDEProxySettings;
    }

    public void setNameForPanel(String nameForPanel) {
        this.nameForPanel = nameForPanel;
    }

    @Override
    public final String getNameForPanel() {
        return this.nameForPanel;
    }

    @Override
    public ActivationDialogNew getDialog() {
        return this.dialog;
    }

    @Override
    public void setDialog(ActivationDialogNew dialog) {
        this.dialog = dialog;
    }

    @Override
    public ButtonData[] getButtonData() {
        return null;
    }

    @Override
    public void onButtonPressed(int buttonId) {
        log.trace("PanelAbstract.buttonPressed() " + buttonId);
        switch (buttonId) {
            case 1025: {
                this.onFirstButton();
                break;
            }
            case 1026: {
                this.onSecondButton();
                break;
            }
            case 1027: {
                this.onThirdButton();
                break;
            }
        }
    }

    protected void onFirstButton() {
    }

    protected void onSecondButton() {
    }

    protected void onThirdButton() {
    }

    @Override
    public void showMessage(ActivationPanelMessage message) {
        log.trace("PanelAbstract.showMessage() " + message.getType() + " " + message.getText());
        String newMessage = this.processMessage(message.getText());
        log.trace(" ********* new mess " + newMessage);
        this.lastMessage = newMessage;
        if (this.progressLabel != null) {
            this.progressLabel.setIcon(PanelAbstract.translateMessageTypeToImage(message)).setText(newMessage).setTextColor(PanelAbstract.translateMessageTypeToColor(message)).show();
        } else {
            log.debug(newMessage);
            RebelLog.eclipseError("Could not show the message. Container is null.", new RuntimeException(newMessage));
        }
        if (message.getType().equals((Object)ActivationPanelMessage.Type.IN_PROGRESS)) {
            this.disableFormFields();
        } else {
            this.enableFormFields();
        }
    }

    private static Image translateMessageTypeToImage(ActivationPanelMessage message) {
        switch (message.getType()) {
            case ERROR: {
                return RebelImage.MESSAGE_ERROR.getImage();
            }
            case IN_PROGRESS: {
                return RebelImage.MESSAGE_INFO.getImage();
            }
            case SUCCESS: {
                return RebelImage.MESSAGE_SUCCESS.getImage();
            }
        }
        return null;
    }

    private static int translateMessageTypeToColor(ActivationPanelMessage message) {
        switch (message.getType()) {
            case ERROR: {
                return 3;
            }
            case IN_PROGRESS: {
                return 9;
            }
            case SUCCESS: {
                return 6;
            }
        }
        return 2;
    }

    protected String processMessage(String message) {
        return Messages.processMessage((String)message, this::setFieldToInvalid);
    }

    public String getMessage() {
        return this.progressLabel == null ? null : this.lastMessage;
    }

    @Override
    public void clearMessage() {
        this.lastMessage = "";
        if (this.progressLabel != null) {
            this.progressLabel.hide();
        }
        this.enableFormFields();
    }

    @Override
    public void setFieldToInvalid(String fieldName) {
    }

    @Override
    public void disableFormFields() {
    }

    @Override
    public void enableFormFields() {
    }

    @Override
    public void onClose() {
    }
}

