/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.ide.common.ui.activation.Messages;

public class PanelConfirmation
extends PanelAbstract {
    private final LicensingStatus licensingStatus;
    private static final Pattern p = Pattern.compile("Email address '(.*)' has already been used");

    public PanelConfirmation(DialogController controller, LicensingStatus licensingStatus) {
        super(controller);
        this.licensingStatus = licensingStatus;
    }

    @Override
    public Control getControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        int hspan = 2;
        GridLayout containerLayout = new GridLayout(hspan, false);
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.createNewLine(container, hspan);
        String message1 = null;
        String message2 = null;
        boolean showSuccessText = false;
        if (this.licensingStatus.isEvaluation() && this.licensingStatus.isValid() || this.licensingStatus.isActivationPending()) {
            showSuccessText = true;
            if (this.licensingStatus.isActivationPending()) {
                message1 = "Trial pending email verification. Please complete email verification.";
            } else if (this.dialog.getLicenseTracker().isTrialActivated()) {
                message1 = Messages.getTrialActivatedMessage((LicensingStatus)this.licensingStatus);
            } else {
                message1 = Messages.getTrialActiveMessage((LicensingStatus)this.licensingStatus);
                message2 = "Do you want to change your license?";
            }
        } else if (!this.licensingStatus.isEvaluation() && this.licensingStatus.isValid()) {
            showSuccessText = true;
            message1 = Messages.getLicenseActivatedMessage((LicensingStatus)this.licensingStatus);
        } else if (this.licensingStatus.isEvaluation() && this.licensingStatus.isExpired()) {
            message1 = Messages.getTrialExpiredMessage((LicensingStatus)this.licensingStatus);
        } else if (!this.licensingStatus.isEvaluation() && this.licensingStatus.isExpired()) {
            message1 = Messages.getLicenseExpiredMessage((LicensingStatus)this.licensingStatus);
        } else {
            String errorText = this.licensingStatus.hasError() ? this.licensingStatus.errorMessage.getText() : null;
            Matcher m = p.matcher(errorText);
            if (errorText != null && errorText.contains("\"status\":-4") && m.find()) {
                message1 = String.format("This email has already been used for a JRebel trial.<br>(%s)", m.group(1));
            } else {
                String string = message1 = errorText != null ? errorText : "Error reading license";
            }
        }
        if (showSuccessText) {
            if (this.licensingStatus.isActivationPending()) {
                this.setControlHspan((Control)this.createLabel(container, "Account verification pending", 200, new Color((Device)container.getDisplay(), 143, 185, 30), 1), hspan);
            } else {
                this.setControlHspan((Control)this.createLabel(container, "JRebel activated", 200, new Color((Device)container.getDisplay(), 143, 185, 30), 1), hspan);
            }
        } else {
            this.setControlHspan((Control)this.createLabel(container, "JRebel Trial has ended", 200, -1, 1), hspan);
        }
        this.createNewLine(container, hspan);
        if (message1 == null) {
            message1 = "ERROR: message is not available";
        }
        this.setControlHspan((Control)this.createLabel(container, message1, 100, -1), hspan);
        if (message2 != null) {
            this.createNewLine(container, hspan);
            this.setControlHspan((Control)this.createLabel(container, message2, 100, -1, 1), hspan);
        }
        return container;
    }

    private boolean isValidTrialAndActivated() {
        return this.licensingStatus.isValid() && this.licensingStatus.isEvaluation() && this.dialog.getLicenseTracker().isTrialActivated();
    }

    @Override
    public ButtonData[] getButtonData() {
        if (this.isValidTrialAndActivated()) {
            return new ButtonData[]{new ButtonData("Buy a license", true), new ButtonData("Open JRebel Configuration", true)};
        }
        if (this.licensingStatus.isValid() && !this.licensingStatus.isEvaluation()) {
            return new ButtonData[]{new ButtonData("Open JRebel Configuration", true)};
        }
        if (this.licensingStatus.isEvaluation() && this.licensingStatus.isExpired()) {
            return new ButtonData[]{new ButtonData("Contact us", true), new ButtonData("Enter a license", true)};
        }
        return new ButtonData[]{new ButtonData("Buy a license", true), new ButtonData("Close", true)};
    }

    @Override
    protected void onFirstButton() {
        if (this.isValidTrialAndActivated()) {
            BrowserUtil.silentOpenLink((String)"https://www.jrebel.com/products/jrebel/chat-pricing-request?source=eclipse-config");
            this.dialog.close();
        } else if (this.licensingStatus.isValid() && !this.licensingStatus.isEvaluation()) {
            this.controller.onButtonOpenConfigCenter(this);
            this.dialog.close();
        } else if (this.licensingStatus.isEvaluation() && this.licensingStatus.isExpired()) {
            this.controller.onButtonExtendTrial(this, this.licensingStatus);
        } else {
            BrowserUtil.silentOpenLink((String)"https://www.jrebel.com/products/jrebel/chat-pricing-request?source=eclipse-config");
            this.dialog.close();
        }
    }

    @Override
    protected void onSecondButton() {
        if (this.isValidTrialAndActivated()) {
            this.controller.onButtonOpenConfigCenter(this);
            this.dialog.close();
        } else if (this.licensingStatus.isValid() && !this.licensingStatus.isEvaluation()) {
            this.dialog.close();
        } else if (this.licensingStatus.isEvaluation() && this.licensingStatus.isExpired()) {
            this.dialog.switchToTab(0);
        } else {
            this.dialog.close();
        }
    }

    @Override
    protected void onThirdButton() {
        this.dialog.close();
    }
}

