/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.common.util.LicenseUtils;
import org.zeroturnaround.eclipse.config.components.FileSelectionComponent;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.eclipse.config.ui.newactivation.validator.ZtEmailValidator;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.LicenseSource;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.ide.common.ui.activation.ActivationPanelMessage;
import org.zeroturnaround.jrebel.ide.common.ui.activation.JRebelLicenseActivationPanel;

public class PanelLicenseActivation
extends PanelAbstract {
    private static final String ERROR_FILE_NOT_EXISTS = "License file does not exist.";
    private final LicensingStatus initialLicenseStatus;
    private Button radioChooseLicenseFile;
    private Button radioPasteLicenseCode;
    private Button radioSpecifyLicenseServer;
    private Text textLicenseCode;
    private FileSelectionComponent textLicenseFilePath;
    private Text textLicenseServerPath;
    private Text textLicenseServerEmail;
    private int radioIndent = 0;
    private int textBoxIndent = 20;
    private final ZtEmailValidator ztEmailValidator = new ZtEmailValidator(true);
    private final Watcher.Listener licensingListener;
    private boolean isInitialized = false;

    public PanelLicenseActivation(DialogController controller, LicensingStatus initialLicenseStatus) {
        super(controller);
        this.initialLicenseStatus = initialLicenseStatus;
        this.licensingListener = newStatus -> EclipseUtil.runInUiThread(() -> this.dialog.setLicensingStatus(newStatus));
    }

    @Override
    public Control getControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        int hCols = 2;
        GridLayout containerLayout = new GridLayout(hCols, false);
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        containerLayout.horizontalSpacing = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label newline = new Label(container, 0);
        newline.setText("   ");
        GridData layoutData = new GridData(4, 4, true, true, hCols, 1);
        layoutData.minimumWidth = 400;
        newline.setLayoutData((Object)layoutData);
        Label label = new Label(container, 0);
        FontData fontData = label.getFont().getFontData()[0];
        Font font = new Font((Device)parent.getDisplay(), new FontData(fontData.getName(), fontData.getHeight() * 12 / 10, 1));
        label.setFont(font);
        GridData labelGridData = new GridData(4, 4, true, true, hCols, 1);
        label.setLayoutData((Object)labelGridData);
        this.progressLabel = this.createProgressLabel(container, hCols, (Widget)parent);
        this.progressLabel.hide();
        JRebelLicenseActivationPanel.Data initialData = this.controller.getInitialData();
        if (this.initialLicenseStatus.isValid() && !this.initialLicenseStatus.isEvaluation()) {
            label.setText("JRebel activated");
            if (this.initialLicenseStatus.license.getValidUntil() != null) {
                String text = null;
                if (this.initialLicenseStatus.license.isOfflineLease()) {
                    text = String.format(Locale.ENGLISH, "Your offline seat expires on %1$tB %1$te, %1$tY %1$tR.", this.initialLicenseStatus.license.getValidUntil());
                } else if (this.initialLicenseStatus.license.getLicenseSource() != LicenseSource.SERVER) {
                    text = String.format(Locale.ENGLISH, "Your JRebel license expires on %1$tB %1$te, %1$tY.", this.initialLicenseStatus.license.getValidUntil());
                }
                if (text != null) {
                    this.progressLabel.setText(text).setIcon(null).setTextColor(2).show();
                }
            }
        } else if (!this.initialLicenseStatus.isEvaluation() && this.initialLicenseStatus.isExpired()) {
            label.setText("JRebel has expired");
            if (this.initialLicenseStatus.license.getValidUntil() != null) {
                this.progressLabel.setText(String.format(Locale.ENGLISH, "Your JRebel license expired on %1$tB %1$te, %1$tY.", this.initialLicenseStatus.license.getValidUntil())).setIcon(null).setTextColor(2).show();
            }
        } else if (this.initialLicenseStatus.isLoading()) {
            this.progressLabel.setText("Checking license status...").setIcon(RebelImage.MESSAGE_INFO.getImage()).setTextColor(2).show();
        } else if (LicenseUtils.isPreferredLicenseServer() && !initialData.getLicenseServerAddress().isEmpty()) {
            if (this.initialLicenseStatus.isValid()) {
                label.setText("JRebel activated");
            } else if (this.initialLicenseStatus.hasError()) {
                this.showMessage(new ActivationPanelMessage(this.initialLicenseStatus));
                if (this.initialLicenseStatus.isActivationPending()) {
                    label.setText("Account verification pending");
                } else {
                    label.setVisible(false);
                    labelGridData.exclude = true;
                }
            }
        } else {
            label.setText("Activate JRebel with:");
        }
        this.createLicenseServerComposite(container, hCols);
        this.createLicenseFileComposite(container, hCols);
        this.createActivationCodeComposite(container, hCols);
        this.createNewLine(container, hCols);
        this.initWithData(initialData);
        this.textLicenseCode.addModifyListener(e -> this.updateDialogButtons());
        this.textLicenseFilePath.getLocationText().addModifyListener(e -> this.updateDialogButtons());
        this.textLicenseServerPath.addModifyListener(e -> this.updateDialogButtons());
        this.textLicenseServerEmail.addModifyListener(e -> this.updateDialogButtons());
        Watcher.getInstance().listenForLicenseChange(this.licensingListener);
        this.isInitialized = true;
        return container;
    }

    private void createActivationCodeComposite(Composite container, int hCols) {
        this.radioPasteLicenseCode = new Button(container, 16);
        this.radioPasteLicenseCode.setText("Activation code");
        this.radioPasteLicenseCode.setLayoutData((Object)this.buildGridDataWithIndent(this.radioIndent, 0, hCols));
        this.textLicenseCode = new Text(container, 2626);
        GridData liceseCodeGridData = new GridData(1808);
        liceseCodeGridData.heightHint = this.textLicenseCode.getLineHeight() * 8;
        liceseCodeGridData.horizontalIndent = this.textBoxIndent;
        liceseCodeGridData.horizontalSpan = hCols;
        this.setFixedWidthLayout((Control)this.textLicenseCode, liceseCodeGridData);
        this.radioPasteLicenseCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PanelLicenseActivation.this.clearMessage();
                PanelLicenseActivation.this.textLicenseCode.setEnabled(PanelLicenseActivation.this.radioPasteLicenseCode.getSelection());
                PanelLicenseActivation.this.updateSelectedSection();
                PanelLicenseActivation.this.updateDialogButtons();
            }
        });
    }

    private void createLicenseFileComposite(Composite container, int hCols) {
        this.radioChooseLicenseFile = new Button(container, 16);
        this.radioChooseLicenseFile.setText("License file from the hard drive (jrebel.lic)");
        this.radioChooseLicenseFile.setLayoutData((Object)this.buildGridDataWithIndent(this.radioIndent, 0, hCols));
        this.textLicenseFilePath = new FileSelectionComponent(container, 0, false, false);
        GridData layoutData = new GridData(4, 0x1000000, true, false, hCols, 1);
        layoutData.horizontalIndent = this.textBoxIndent;
        this.textLicenseFilePath.setLayoutData(layoutData);
        this.textLicenseFilePath.setFileNameWhenEmpty("jrebel.lic");
        this.textLicenseFilePath.setFilterNames(new String[]{"JRebel license file (jrebel.lic, *.lic)"});
        this.textLicenseFilePath.setFilterExtensions(new String[]{"*.lic"});
        this.setFixedWidthLayout((Control)this.textLicenseFilePath, layoutData);
        this.radioChooseLicenseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File defaultLicense;
                PanelLicenseActivation.this.clearMessage();
                PanelLicenseActivation.this.textLicenseFilePath.setEnabled(PanelLicenseActivation.this.radioChooseLicenseFile.getSelection());
                if (PanelLicenseActivation.this.radioChooseLicenseFile.getSelection() && PanelLicenseActivation.this.textLicenseFilePath.getText().trim().length() == 0 && (defaultLicense = LicenseUtils.findDefaultLicenseFile()) != null) {
                    PanelLicenseActivation.this.textLicenseFilePath.setText(defaultLicense.getAbsolutePath());
                }
                PanelLicenseActivation.this.updateSelectedSection();
                PanelLicenseActivation.this.updateDialogButtons();
            }
        });
    }

    private void createLicenseServerComposite(Composite container, int hCols) {
        this.radioSpecifyLicenseServer = new Button(container, 16);
        this.radioSpecifyLicenseServer.setText("Team URL (connect to online licensing service)");
        this.radioSpecifyLicenseServer.setLayoutData((Object)this.buildGridDataWithIndent(this.radioIndent, 0, 1, 0));
        this.textLicenseServerPath = new Text(container, 2052);
        this.textLicenseServerPath.setMessage("Team URL (required)");
        this.setFixedWidthLayout((Control)this.textLicenseServerPath, this.buildGridDataWithIndent(this.textBoxIndent, 0, hCols));
        this.textLicenseServerEmail = new Text(container, 2052);
        this.textLicenseServerEmail.setMessage("Email address (required)");
        this.setFixedWidthLayout((Control)this.textLicenseServerEmail, this.buildGridDataWithIndent(this.textBoxIndent, 0, hCols));
        this.radioSpecifyLicenseServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PanelLicenseActivation.this.clearMessage();
                PanelLicenseActivation.this.textLicenseServerPath.setEnabled(PanelLicenseActivation.this.radioSpecifyLicenseServer.getSelection());
                PanelLicenseActivation.this.textLicenseServerEmail.setEnabled(PanelLicenseActivation.this.radioSpecifyLicenseServer.getSelection());
                PanelLicenseActivation.this.updateSelectedSection();
                PanelLicenseActivation.this.updateDialogButtons();
            }
        });
    }

    @Override
    public void onClose() {
        Watcher.getInstance().removeLicenseChangeListener(this.licensingListener);
        super.onClose();
    }

    private void updateDialogButtons() {
        this.dialog.enableActivateButton(this.isDataValidForActivation());
        this.assertLicenseFileExists();
    }

    private void initWithData(JRebelLicenseActivationPanel.Data data) {
        this.textLicenseCode.setText(data.getActivationCodeText());
        if (data.getLicenseFile() != null) {
            this.textLicenseFilePath.setText(data.getLicenseFile().getAbsolutePath());
        }
        this.textLicenseServerEmail.setText(data.getEmail());
        this.textLicenseServerPath.setText(data.getLicenseServerAddress());
        this.radioPasteLicenseCode.setSelection(false);
        this.radioChooseLicenseFile.setSelection(false);
        this.radioSpecifyLicenseServer.setSelection(false);
        switch (data.getMode()) {
            case ACTIVATION_CODE: {
                this.radioPasteLicenseCode.setSelection(true);
                break;
            }
            case LICENSE_FILE: {
                this.radioChooseLicenseFile.setSelection(true);
                if (data.getLicenseFile() != null) break;
                this.showDefaultLicenseFilePathIfPossible();
                break;
            }
            case LICENSE_SERVER: {
                this.radioSpecifyLicenseServer.setSelection(true);
                break;
            }
        }
        this.updateSelectedSection();
    }

    private void showDefaultLicenseFilePathIfPossible() {
        File defaultLicenseFile = LicenseUtils.findDefaultLicenseFile();
        if (defaultLicenseFile != null) {
            this.textLicenseFilePath.setText(defaultLicenseFile.getAbsolutePath());
        }
    }

    private void assertLicenseFileExists() {
        if (this.radioChooseLicenseFile.getSelection() && this.radioChooseLicenseFile.isEnabled()) {
            String filePath = this.textLicenseFilePath.getText();
            if (filePath.trim().toLowerCase(Locale.ENGLISH).endsWith(".lic")) {
                File licenseFile = new File(filePath);
                if (licenseFile.isFile()) {
                    if (ERROR_FILE_NOT_EXISTS.equals(this.getMessage())) {
                        this.clearMessage();
                    }
                } else if (this.getMessage() != null && this.getMessage().isEmpty()) {
                    this.showMessage(new ActivationPanelMessage(ERROR_FILE_NOT_EXISTS, ActivationPanelMessage.Type.ERROR));
                }
            }
        } else if (ERROR_FILE_NOT_EXISTS.equals(this.getMessage())) {
            this.clearMessage();
        }
    }

    private void updateSelectedSection() {
        this.textLicenseCode.setEnabled(false);
        this.textLicenseFilePath.setEnabled(false);
        this.textLicenseServerPath.setEnabled(false);
        this.textLicenseServerEmail.setEnabled(false);
        if (this.radioChooseLicenseFile.getSelection() && this.radioChooseLicenseFile.isEnabled()) {
            this.textLicenseFilePath.setEnabled(true);
        } else if (this.radioPasteLicenseCode.getSelection() && this.radioPasteLicenseCode.isEnabled()) {
            this.textLicenseCode.setEnabled(true);
        } else if (this.radioSpecifyLicenseServer.getSelection() && this.radioSpecifyLicenseServer.isEnabled()) {
            this.textLicenseServerPath.setEnabled(true);
            this.textLicenseServerEmail.setEnabled(true);
        }
        this.assertLicenseFileExists();
    }

    @Override
    public ButtonData[] getButtonData() {
        String firstButtonLabel = this.initialLicenseStatus.isValid() && !this.initialLicenseStatus.isEvaluation() ? "Change license" : "Activate JRebel";
        return new ButtonData[]{new ButtonData(firstButtonLabel, this.isDataValidForActivation())};
    }

    private boolean isDataValidForActivation() {
        if (this.radioChooseLicenseFile.getSelection()) {
            return this.isValidInfoToActivateFromFile();
        }
        if (this.radioPasteLicenseCode.getSelection()) {
            return this.isValidForPasted();
        }
        if (this.radioSpecifyLicenseServer.getSelection()) {
            return this.isValidForLicenseServer();
        }
        return false;
    }

    private boolean isValidInfoToActivateFromFile() {
        String filePath = this.textLicenseFilePath.getText().trim();
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File licFile = new File(filePath);
        return licFile.isFile();
    }

    private boolean isValidForPasted() {
        String text = this.textLicenseCode.getText().trim();
        return !StringUtils.isEmpty((CharSequence)text);
    }

    private boolean isValidForLicenseServer() {
        String licenseServer = this.textLicenseServerPath.getText().trim();
        boolean validToken = false;
        if (StringUtils.isEmpty((CharSequence)licenseServer)) {
            validToken = false;
        }
        try {
            new URL(licenseServer);
            validToken = true;
        }
        catch (MalformedURLException malformedURLException) {
            validToken = false;
        }
        return validToken;
    }

    @Override
    protected void onFirstButton() {
        String activationCodeText = this.textLicenseCode.getText();
        File licenseFile = new File(this.textLicenseFilePath.getText().trim());
        String licenseServerAddress = this.textLicenseServerPath.getText();
        String email = this.textLicenseServerEmail.getText();
        JRebelLicenseActivationPanel.Data data = new JRebelLicenseActivationPanel.Data(this.getSelectedMode(), activationCodeText, licenseFile, licenseServerAddress, email, false);
        if (data.getMode() == JRebelLicenseActivationPanel.Mode.LICENSE_SERVER) {
            if (email.isEmpty()) {
                this.showMessage(new ActivationPanelMessage("Email address is required.", ActivationPanelMessage.Type.ERROR));
                return;
            }
            if (!this.ztEmailValidator.isValid(email)) {
                this.showMessage(new ActivationPanelMessage("Invalid email address.", ActivationPanelMessage.Type.ERROR));
                return;
            }
        }
        this.underActivation = true;
        this.controller.onButtonActivate_async(this, data);
    }

    @NotNull
    private JRebelLicenseActivationPanel.Mode getSelectedMode() {
        if (this.radioChooseLicenseFile.getSelection()) {
            return JRebelLicenseActivationPanel.Mode.LICENSE_FILE;
        }
        if (this.radioPasteLicenseCode.getSelection()) {
            return JRebelLicenseActivationPanel.Mode.ACTIVATION_CODE;
        }
        if (this.radioSpecifyLicenseServer.getSelection()) {
            return JRebelLicenseActivationPanel.Mode.LICENSE_SERVER;
        }
        throw new IllegalStateException("Could not detect activation mode");
    }

    @Override
    protected void onSecondButton() {
        this.controller.onButtonCancel(this);
    }

    @Override
    public void disableFormFields() {
        if (this.isInitialized) {
            this.radioPasteLicenseCode.setEnabled(false);
            this.radioChooseLicenseFile.setEnabled(false);
            this.radioSpecifyLicenseServer.setEnabled(false);
            this.updateSelectedSection();
            this.dialog.enableActivateButton(false);
        }
    }

    @Override
    public void enableFormFields() {
        if (this.isInitialized) {
            this.radioPasteLicenseCode.setEnabled(true);
            this.radioChooseLicenseFile.setEnabled(true);
            this.radioSpecifyLicenseServer.setEnabled(true);
            this.updateSelectedSection();
            this.dialog.enableActivateButton(this.isDataValidForActivation());
        }
    }
}

