/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.jrebel.client.spi.Product;
import org.zeroturnaround.jrebel.ide.common.utils.WebLink;

public class PanelOfflineActivation
extends PanelAbstract {
    private Text textLicenseCode;

    public PanelOfflineActivation(DialogController controller) {
        super(controller);
    }

    @Override
    public Control getControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.createNewLine(container, 1);
        Link link = this.buildLink(container, "Sign up for a free 14-day Trial on JRebel website.", WebLink.getOfflineRegistrationLink((Product)Product.ECLIPSE));
        SWTUtil.setFontSize((Control)link, 120);
        link.setForeground(parent.getDisplay().getSystemColor(5));
        this.progressLabel = this.createProgressLabel(container, 1, (Widget)parent);
        this.progressLabel.hide();
        this.createLabel(container, "Enter activation code:", 120, -1);
        this.textLicenseCode = this.createMultilineText(container, this::updateDialogButtons);
        return container;
    }

    @Override
    public ButtonData[] getButtonData() {
        ButtonData[] data = new ButtonData[]{new ButtonData("Activate JRebel", this.isDataValidForActivation())};
        return data;
    }

    private boolean isDataValidForActivation() {
        return this.textLicenseCode.getText().trim().length() != 0;
    }

    @Override
    protected void onFirstButton() {
        this.controller.onButtonActivate(this, this.textLicenseCode.getText());
    }

    @Override
    public void disableFormFields() {
        super.disableFormFields();
        this.textLicenseCode.setEnabled(false);
        this.dialog.enableActivateButton(false);
    }

    @Override
    public void enableFormFields() {
        super.enableFormFields();
        this.textLicenseCode.setEnabled(true);
        this.updateDialogButtons();
    }

    private void updateDialogButtons() {
        this.dialog.enableActivateButton(StringUtils.isNotBlank((CharSequence)this.textLicenseCode.getText()));
    }
}

