/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.newactivation;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.zeroturnaround.common.util.BrowserUtil;
import org.zeroturnaround.eclipse.config.ui.newactivation.ButtonData;
import org.zeroturnaround.eclipse.config.ui.newactivation.DialogController;
import org.zeroturnaround.eclipse.config.ui.newactivation.FieldTextWithValidator;
import org.zeroturnaround.eclipse.config.ui.newactivation.PanelAbstract;
import org.zeroturnaround.eclipse.config.ui.newactivation.validator.PhoneNumberValidator;
import org.zeroturnaround.eclipse.config.ui.newactivation.validator.StringLengthValidator;
import org.zeroturnaround.eclipse.config.ui.newactivation.validator.ZtEmailValidator;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensingImpl;
import org.zeroturnaround.jrebel.client.licensing.LicensingStatus;
import org.zeroturnaround.jrebel.client.licensing.TrialRegistrationFormData;
import org.zeroturnaround.jrebel.ide.common.ui.activation.ActivationPanelMessage;

public class PanelOnlineActivation
extends PanelAbstract {
    private FieldTextWithValidator textFirstname;
    private FieldTextWithValidator textLastName;
    private FieldTextWithValidator textEmail;
    private FieldTextWithValidator textPhone;
    private FieldTextWithValidator textCompany;
    private FieldTextWithValidator[] textsAll;
    private Button checkboxTOS;

    public PanelOnlineActivation(DialogController controller) {
        super(controller);
    }

    @Override
    public Control getControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        int hCols = 3;
        GridLayout containerLayout = new GridLayout(hCols, false);
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createNewLine(container, hCols);
        Label label = this.createLabel(container, "Get started with a free 14-day JRebel Trial.", 120, -1, 1);
        label.setLayoutData((Object)new GridData(4, 4, true, false, hCols, 1));
        this.progressLabel = this.createProgressLabel(container, hCols, (Widget)parent);
        this.progressLabel.hide();
        Runnable commonModifyRunnable = this::updateDialogButtons;
        TrialRegistrationFormData formData = TrialRegistrationFormData.preFilled();
        this.textFirstname = new FieldTextWithValidator(container, 0, "First name", "", new StringLengthValidator(), commonModifyRunnable);
        this.textLastName = new FieldTextWithValidator(container, 0, "Last name", "", new StringLengthValidator(), commonModifyRunnable);
        this.textEmail = new FieldTextWithValidator(container, 0, "Email", "", new ZtEmailValidator(), commonModifyRunnable);
        this.textPhone = new FieldTextWithValidator(container, 0, "Phone", "", new PhoneNumberValidator(), commonModifyRunnable);
        this.textCompany = new FieldTextWithValidator(container, 0, "Company", "", new StringLengthValidator(), commonModifyRunnable);
        this.textsAll = new FieldTextWithValidator[]{this.textFirstname, this.textLastName, this.textEmail, this.textPhone, this.textCompany};
        ((Text)this.textFirstname.getMainComponent()).setMessage("First name (required)");
        ((Text)this.textLastName.getMainComponent()).setMessage("Last name (required)");
        ((Text)this.textEmail.getMainComponent()).setMessage("Email (required)");
        ((Text)this.textPhone.getMainComponent()).setMessage("Phone (required)");
        ((Text)this.textCompany.getMainComponent()).setMessage("Company (required)");
        this.createEvalConsentLabel(container, hCols);
        this.checkboxTOS = this.createTosCheckbox(container, hCols, commonModifyRunnable);
        container.setTabList(new Control[]{this.textFirstname.getMainComponent(), this.textLastName.getMainComponent(), this.textEmail.getMainComponent(), this.textPhone.getMainComponent(), this.textCompany.getMainComponent(), this.checkboxTOS.getParent()});
        EclipseUtil.runInUiThread(() -> {
            if (!StringUtils.isEmpty((CharSequence)formData.getFirstName())) {
                this.textFirstname.setText(formData.getFirstName());
            }
            if (!StringUtils.isEmpty((CharSequence)formData.getLastName())) {
                this.textLastName.setText(formData.getLastName());
            }
        });
        LicensingStatus licensingStatus = new JRebelLicensingImpl().getLicensingStatus();
        if (licensingStatus.isActivationPending()) {
            this.showMessage(new ActivationPanelMessage(licensingStatus));
        }
        return container;
    }

    private void createEvalConsentLabel(Composite container, int hCols) {
        Composite trialConsentContainer = new Composite(container, 0);
        trialConsentContainer.setLayoutData((Object)new GridData(4, 4, true, false, hCols, 1));
        GridLayout trialConsentLayout = new GridLayout(hCols, false);
        trialConsentLayout.marginTop = 30;
        trialConsentContainer.setLayout((Layout)trialConsentLayout);
        Link trialConsent = new Link(trialConsentContainer, 0);
        trialConsent.setText("By submitting this form, you agree to being contacted with regard to\nJRebel evaluation. <a>More information</a>.");
        trialConsent.addListener(13, e -> BrowserUtil.silentOpenLink((String)"https://jrebel.com/legal/jrebel-eval-data-processing"));
    }

    private void updateDialogButtons() {
        this.dialog.enableActivateButton(this.isDataValidForActivation());
    }

    @Override
    public ButtonData[] getButtonData() {
        return new ButtonData[]{new ButtonData("Activate JRebel", this.isDataValidForActivation())};
    }

    private boolean isDataValidForActivation() {
        return this.textFirstname.isDataValid() && this.textLastName.isDataValid() && this.textEmail.isDataValid() && this.textPhone.isDataValid() && this.textCompany.isDataValid() && this.checkboxTOS.getSelection();
    }

    @Override
    public void setFieldToInvalid(String fieldName) {
        if (fieldName.equals("first_name")) {
            this.textFirstname.setInvalid();
        } else if (fieldName.equals("last_name")) {
            this.textLastName.setInvalid();
        } else if (fieldName.equals("phone")) {
            this.textPhone.setInvalid();
        } else if (fieldName.equals("organization")) {
            this.textCompany.setInvalid();
        } else if (fieldName.equals("email")) {
            this.textEmail.setInvalid();
        }
    }

    @Override
    protected void onFirstButton() {
        String firstName = this.textFirstname.getText();
        String lastName = this.textLastName.getText();
        String email = this.textEmail.getText();
        String phone = this.textPhone.getText();
        String company = this.textCompany.getText();
        String installationGuid = new JRebelLicensingImpl().getGuid();
        TrialRegistrationFormData formData = new TrialRegistrationFormData(firstName, lastName, email, phone, company, installationGuid);
        this.underActivation = true;
        this.controller.onButtonStartTrial_async(this, formData);
    }

    @Override
    public void disableFormFields() {
        FieldTextWithValidator[] fieldTextWithValidatorArray = this.textsAll;
        int n = this.textsAll.length;
        int n2 = 0;
        while (n2 < n) {
            FieldTextWithValidator text = fieldTextWithValidatorArray[n2];
            text.setEnabled(false);
            ++n2;
        }
        this.checkboxTOS.setEnabled(false);
        this.dialog.enableActivateButton(false);
    }

    @Override
    public void enableFormFields() {
        FieldTextWithValidator[] fieldTextWithValidatorArray = this.textsAll;
        int n = this.textsAll.length;
        int n2 = 0;
        while (n2 < n) {
            FieldTextWithValidator text = fieldTextWithValidatorArray[n2];
            text.setEnabled(true);
            ++n2;
        }
        this.checkboxTOS.setEnabled(true);
        this.updateDialogButtons();
    }
}

