/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.projects;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;

class ConfigureRemoteServerPrompt
extends Dialog {
    public static final int RESULT_CONFIGURE_PROJECT = 1025;
    public static final int RESULT_ADD_SERVER = 0;
    private final boolean hasWorkspaceServers;

    ConfigureRemoteServerPrompt(Composite parent, boolean hasWorkspaceServers) {
        super(parent.getShell());
        this.hasWorkspaceServers = hasWorkspaceServers;
    }

    protected Control createDialogArea(Composite outerParent) {
        Composite parent = (Composite)super.createDialogArea(outerParent);
        if (this.hasWorkspaceServers) {
            new ZtLabel(parent).text("Press").bold("Enable for workspace").text("to enable remote servers for the whole workspace.");
            new ZtLabel(parent).text("Press").bold("Select for project").text("to select remote servers for this project specifically.");
        } else {
            new ZtLabel(parent).text("Press").bold("Add server").text("to define a new server for the whole workspace.");
        }
        return parent;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.hasWorkspaceServers) {
            newShell.setText("JRebel - no active remote servers");
        } else {
            newShell.setText("JRebel remote server missing");
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, this.hasWorkspaceServers ? "Enable for workspace" : "Add server", true);
        if (this.hasWorkspaceServers) {
            this.createButton(parent, 1025, "Select for project", false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.setReturnCode(1025);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }
}

