/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.projects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsGridGroupRow;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsGridRow;
import org.zeroturnaround.eclipse.config.ui.tools.SwtTools;
import org.zeroturnaround.eclipse.config.ui.widgets.JRebelConfigurationGrid;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedIcon;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextLabel;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.ui.RebelImage;

class ProjectsGrid
extends JRebelConfigurationGrid {
    public static final String ENABLE_JREBEL_TOOLTIP = "Enable or disable JRebel. Generates or removes rebel.xml.";
    public static final String ENABLE_REMOTE_TOOLTIP = "Enable or disable JRebel remote server support. Generates or removes rebel-remote.xml.";
    private final List<ProjectNode> rootNodes = this.readJavaProjects();

    ProjectsGrid(Composite parent) {
        super(parent, 4);
        if (this.rootNodes.isEmpty()) {
            this.container.setBackground(Display.getCurrent().getSystemColor(1));
            new Label(this.container, 0).setText("No Java projects found.");
        } else {
            this.addHeader(this.container);
            this.addRows(this.container);
            SwtTools.addSpacing(this.container.getParent());
        }
    }

    private static void buildProjectStructure(ProjectNode parentNode, IProject[] projects) {
        IProject thisProject = parentNode.getProject();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n3 = 0;
        while (n3 < n) {
            IProject project = iProjectArray[n3];
            if (thisProject.getLocation().isPrefixOf(project.getLocation()) && project.getLocation().segmentCount() - thisProject.getLocation().segmentCount() == 1) {
                parentNode.addChild(new ProjectNode(project));
            }
            ++n3;
        }
        for (ProjectNode childNode : parentNode.getChildren()) {
            ProjectsGrid.buildProjectStructure(childNode, projects);
        }
        Collections.sort(parentNode.getChildren(), (n1, n2) -> n1.getProject().getName().compareToIgnoreCase(n2.getProject().getName()));
    }

    private static void pruneProjectStructure(List<ProjectNode> projectNodes) {
        Iterator<ProjectNode> it = projectNodes.iterator();
        while (it.hasNext()) {
            ProjectNode projectNode = it.next();
            ProjectsGrid.pruneProjectStructure(projectNode.getChildren());
            if (!projectNode.getChildren().isEmpty() || projectNode.getProject().isOpen() && ProjectHelper.isJavaProject(projectNode.getProject())) continue;
            it.remove();
        }
    }

    private static void addExtraJavaFacetChildProjects(List<ProjectNode> projectNodes) {
        for (ProjectNode projectNode : projectNodes) {
            ProjectsGrid.addExtraJavaFacetChildProjects(projectNode.getChildren());
            if (projectNode.getChildren().isEmpty() || !ProjectHelper.isJavaProject(projectNode.getProject())) continue;
            projectNode.getChildren().add(0, new ProjectNode(projectNode.getProject(), true));
        }
    }

    private List<ProjectNode> readJavaProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<ProjectNode> rootNodes = new ArrayList<ProjectNode>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n3 = 0;
        while (n3 < n) {
            IProject project = iProjectArray[n3];
            if (!NestedProjectManager.getInstance().isShownAsNested(project)) {
                rootNodes.add(new ProjectNode(project));
            }
            ++n3;
        }
        Collections.sort(rootNodes, (n1, n2) -> n1.getProject().getName().compareToIgnoreCase(n2.getProject().getName()));
        for (ProjectNode rootNode : rootNodes) {
            ProjectsGrid.buildProjectStructure(rootNode, projects);
        }
        ProjectsGrid.pruneProjectStructure(rootNodes);
        ProjectsGrid.addExtraJavaFacetChildProjects(rootNodes);
        return rootNodes;
    }

    private void addHeader(Composite parent) {
        new SpacedTextLabel(parent, 22).setText("Projects");
        this.addSpacerHeaderCell(parent);
        new SpacedIcon(parent, RebelImage.JREBEL.getImage(), 22, ENABLE_JREBEL_TOOLTIP);
        new SpacedIcon(parent, RebelImage.JREBEL_CLOUD.getImage(), 22, ENABLE_REMOTE_TOOLTIP);
    }

    private void addRows(Composite parent) {
        ProjectsGridGroupRow groupRow = null;
        if (this.rootNodes.size() > 5) {
            groupRow = new ProjectsGridGroupRow(parent, null, 0);
        }
        this.addRows(parent, this.rootNodes, 0, groupRow);
        parent.layout(true, true);
    }

    private void addRows(Composite parent, List<ProjectNode> nodes, int level, ProjectsGridGroupRow parentRow) {
        for (ProjectNode node : nodes) {
            if (node.getChildren().isEmpty()) {
                ProjectsGridRow row = new ProjectsGridRow(parent, node.getProject(), level, node.getLabel());
                if (parentRow == null) continue;
                parentRow.addChildRow(row);
                continue;
            }
            ProjectsGridGroupRow projectGroupRow = new ProjectsGridGroupRow(parent, node.getProject(), level);
            if (parentRow != null) {
                parentRow.addChildRow(projectGroupRow);
            }
            this.addRows(parent, node.getChildren(), level + 1, projectGroupRow);
        }
        if (parentRow != null) {
            parentRow.afterChildRowsAdded();
            if (parentRow.getContainerProject() != null) {
                parentRow.setChildrenHidden(true);
            }
        }
    }

    private static class ProjectNode {
        private final IProject project;
        private final List<ProjectNode> children = new ArrayList<ProjectNode>();
        private final boolean aggregatorWithJavaAspect;

        ProjectNode(IProject project, boolean aggregatorWithJavaAspect) {
            this.project = project;
            this.aggregatorWithJavaAspect = aggregatorWithJavaAspect;
        }

        ProjectNode(IProject project) {
            this(project, false);
        }

        boolean addChild(ProjectNode e) {
            return this.children.add(e);
        }

        IProject getProject() {
            return this.project;
        }

        List<ProjectNode> getChildren() {
            return this.children;
        }

        String getLabel() {
            return this.aggregatorWithJavaAspect ? "(" + this.project.getName() + ")" : this.project.getName();
        }
    }
}

