/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.projects;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.config.ui.dialog.ConfirmEnableJRebel;
import org.zeroturnaround.eclipse.config.ui.projects.IProjectsGridRow;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsGridRow;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedButton;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextAndStatusLabel;
import org.zeroturnaround.eclipse.config.ui.widgets.Spacer;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;

class ProjectsGridGroupRow
implements IProjectsGridRow {
    private static final char ARROW_DOWN = '\u25bc';
    private static final char ARROW_RIGHT = '\u25b6';
    private static final char FIGURE_SPACE = '\u2007';
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(ProjectsGridGroupRow.class);
    private final SpacedTextAndStatusLabel textCell;
    private final SpacedButton jrebelEnabledCheckbox;
    private final SpacedButton remoteServerSupportEnabledCheckbox;
    private int cumulativeSimpleChildProjectsCount;
    private final List<IProjectsGridRow> childRows = new LinkedList<IProjectsGridRow>();
    private final ProjectsGridRow.SelectionChangeListener rowChangeListener;
    private final IProject containerProject;
    private boolean expanded = false;
    private String indent = "";
    private Spacer spacer;

    ProjectsGridGroupRow(final Composite parent, IProject project, int level) {
        this.containerProject = project;
        this.textCell = new SpacedTextAndStatusLabel(parent);
        if (this.containerProject != null) {
            this.indent = StringUtils.repeat((String)"\u2007 ", (int)(level * 2));
            this.updateTitle();
            this.textCell.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    ProjectsGridGroupRow.this.expanded = !ProjectsGridGroupRow.this.expanded;
                    ProjectsGridGroupRow.this.setChildrenHidden(!ProjectsGridGroupRow.this.expanded);
                    ProjectsGridGroupRow.this.updateTitle();
                    ScrollBars.contentsChanged(parent);
                }
            });
        }
        this.spacer = new Spacer(parent, 1);
        this.jrebelEnabledCheckbox = new SpacedButton(parent, 32, "Enable or disable JRebel. Generates or removes rebel.xml.");
        this.jrebelEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsGridGroupRow.this.enableDisableJRebel();
            }
        });
        this.remoteServerSupportEnabledCheckbox = new SpacedButton(parent, 32, "Enable or disable JRebel remote server support. Generates or removes rebel-remote.xml.");
        this.remoteServerSupportEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsGridGroupRow.this.enableDisableRemoteServerSupport();
            }
        });
        this.rowChangeListener = this::updateCheckboxes;
        parent.addDisposeListener(e -> this.cumulativeSimpleChildRowsStream().forEach(row -> row.removeSelectionChangedListener(this.rowChangeListener)));
    }

    private void enableDisableJRebel() {
        this.textCell.setSuccessMessage("");
        final boolean enable = this.jrebelEnabledCheckbox.getSelection();
        if (this.confirmJRebel(enable)) {
            Job job = new Job("JRebel project state change"){

                protected IStatus run(IProgressMonitor m) {
                    ProjectsGridGroupRow.this.enableDisableJRebel(enable, m);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            this.jrebelEnabledCheckbox.setSelection(!enable);
        }
    }

    private void enableDisableJRebel(boolean enable, IProgressMonitor monitor) {
        monitor.beginTask("Starting", this.cumulativeSimpleChildProjectsCount);
        this.cumulativeSimpleChildRowsStream().forEach(row -> {
            monitor.setTaskName("project: " + row.getProjectName());
            row.enableDisableJRebel(enable, false, monitor);
            monitor.worked(1);
        });
        if (enable) {
            this.setSuccessMessage("Redeploy project to apply configuration.");
            consoleLog.info("JRebel enabled for project {}. Redeploy project to apply configuration.", (Object)"all projects");
        } else {
            this.setSuccessMessage("JRebel disabled");
        }
    }

    private void enableDisableRemoteServerSupport() {
        this.textCell.setSuccessMessage("");
        final boolean enable = this.remoteServerSupportEnabledCheckbox.getSelection();
        if (this.confirmRemote(enable)) {
            Job job = new Job("JRebel remote server support state change"){

                protected IStatus run(IProgressMonitor m) {
                    ProjectsGridGroupRow.this.enableDisableJRebelRemoting(enable, m);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            this.remoteServerSupportEnabledCheckbox.setSelection(!enable);
        }
    }

    private void enableDisableJRebelRemoting(boolean enable, IProgressMonitor monitor) {
        monitor.beginTask("Starting", this.cumulativeSimpleChildProjectsCount);
        this.cumulativeSimpleChildRowsStream().forEach(row -> {
            monitor.setTaskName("project: " + row.getProjectName());
            row.enableDisableRemoteServerSupport(enable, false, monitor);
            monitor.worked(1);
        });
        if (enable) {
            this.setSuccessMessage("Redeploy project to apply configuration.");
            consoleLog.info("Remote enabled for project {}. Redeploy project to apply configuration.", (Object)"all projects");
        } else {
            this.setSuccessMessage("Remote server support disabled");
        }
    }

    void afterChildRowsAdded() {
        this.cumulativeSimpleChildProjectsCount = (int)this.cumulativeSimpleChildRowsStream().count();
        this.cumulativeSimpleChildRowsStream().forEach(row -> row.addSelectionChangedListener(this.rowChangeListener));
        this.updateCheckboxes();
    }

    private void setSuccessMessage(String text) {
        EclipseUtil.runInUiThread(() -> this.textCell.setSuccessMessage(text));
    }

    private void updateCheckboxes() {
        long countJRebelEnabled = this.cumulativeSimpleChildRowsStream().filter(row -> row.getJRebelEnabledCheckboxSelection()).count();
        this.jrebelEnabledCheckbox.setSelection(countJRebelEnabled > 0L);
        this.jrebelEnabledCheckbox.setGrayed(countJRebelEnabled > 0L && countJRebelEnabled < (long)this.cumulativeSimpleChildProjectsCount);
        long countRemoteServerSupportEnabled = this.cumulativeSimpleChildRowsStream().filter(row -> row.getRemoteServerSupportCheckboxSelection()).count();
        this.remoteServerSupportEnabledCheckbox.setSelection(countRemoteServerSupportEnabled > 0L);
        this.remoteServerSupportEnabledCheckbox.setGrayed(countRemoteServerSupportEnabled > 0L && countRemoteServerSupportEnabled < (long)this.cumulativeSimpleChildProjectsCount);
    }

    private boolean confirmJRebel(boolean state) {
        if (this.containerProject != null) {
            return true;
        }
        if (state) {
            return ConfirmEnableJRebel.open(this.textCell.getShell(), "Enable JRebel", "Enabling JRebel for all projects might take some time.");
        }
        return MessageDialog.openQuestion((Shell)this.textCell.getShell(), (String)"Disable JRebel", (String)"Are you sure you want to disable JRebel for all projects?");
    }

    private boolean confirmRemote(boolean state) {
        if (this.containerProject != null) {
            return true;
        }
        if (state) {
            return ConfirmEnableJRebel.open(this.textCell.getShell(), "Enable JRebel remote server support", "Enabling JRebel remote server support for all projects might take some time.");
        }
        return MessageDialog.openQuestion((Shell)this.textCell.getShell(), (String)"Disable JRebel remote server support", (String)"Are you sure you want to disable JRebel Remote server support for all projects?");
    }

    public void addChildRow(IProjectsGridRow row) {
        this.childRows.add(row);
    }

    public IProject getContainerProject() {
        return this.containerProject;
    }

    @Override
    public void setHidden(boolean hidden) {
        Control[] controlArray = new Control[]{this.textCell, this.spacer, this.jrebelEnabledCheckbox, this.remoteServerSupportEnabledCheckbox};
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setVisible(!hidden);
            GridData layoutData = (GridData)control.getLayoutData();
            layoutData.exclude = hidden;
            ++n2;
        }
        if (hidden) {
            this.expanded = !hidden;
            this.updateTitle();
            this.setChildrenHidden(hidden);
        }
    }

    void setChildrenHidden(boolean hidden) {
        for (IProjectsGridRow row : this.childRows) {
            row.setHidden(hidden);
        }
    }

    private Stream<ProjectsGridRow> cumulativeSimpleChildRowsStream() {
        return this.childRows.stream().flatMap(row -> row instanceof ProjectsGridGroupRow ? ((ProjectsGridGroupRow)row).cumulativeSimpleChildRowsStream() : Stream.of((ProjectsGridRow)row));
    }

    private void updateTitle() {
        this.textCell.setText(String.valueOf(this.indent) + (this.expanded ? (char)'\u25bc' : '\u25b6') + " " + this.containerProject.getName());
    }
}

