/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.projects;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.config.ui.projects.ConfigureRemoteServerPrompt;
import org.zeroturnaround.eclipse.config.ui.projects.IProjectsGridRow;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedButton;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedIcon;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextAndStatusLabel;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

class ProjectsGridRow
implements IProjectsGridRow {
    private static final Log log = Log.getInstance(ProjectsGridRow.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(ProjectsGridRow.class);
    private final IProject project;
    private final Composite parent;
    private final SpacedTextAndStatusLabel textCell;
    private final SpacedIcon editButton;
    private final SpacedButton jrebelEnabledCheckbox;
    private final SpacedButton remoteServerSupportEnabledCheckbox;
    private final List<SelectionChangeListener> selectionChangeListeners = new CopyOnWriteArrayList<SelectionChangeListener>();
    private boolean parentGotDisposedEvent = false;

    ProjectsGridRow(Composite parent, IProject project, int level, String label) {
        this.project = project;
        this.parent = parent;
        this.textCell = new SpacedTextAndStatusLabel(parent);
        String indent = StringUtils.repeat((String)"\u2007 ", (int)(level * 2));
        String text = String.valueOf(indent) + label;
        this.textCell.setText(text);
        this.editButton = new SpacedIcon(parent, RebelImage.EDIT_PENCIL.getImage(), 1, "Edit", () -> this.onEditClicked());
        this.editButton.setDisabledButtonImage(RebelImage.EDIT_PENCIL_DISABLED.getImage());
        this.updateEditButton();
        this.jrebelEnabledCheckbox = new SpacedButton(parent, 32, "Enable or disable JRebel. Generates or removes rebel.xml.");
        this.jrebelEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ProjectsGridRow.this.enableDisableJRebelInteractive(button.getSelection());
            }
        });
        this.remoteServerSupportEnabledCheckbox = new SpacedButton(parent, 32, "Enable or disable JRebel remote server support. Generates or removes rebel-remote.xml.");
        this.remoteServerSupportEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ProjectsGridRow.this.enableDisableRemoteServerSupportInteractive(button.getSelection());
            }
        });
        this.updateUi();
        final RemoteServerConfigurations.ChangeListener remoteListener = () -> EclipseUtil.runInUiThread(this::updateUi);
        IdeRemoting.getInstance().getConfigurations().addListener(remoteListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProjectsGridRow.this.parentGotDisposedEvent = true;
                IdeRemoting.getInstance().getConfigurations().removeListener(remoteListener);
            }
        });
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public boolean getJRebelEnabledCheckboxSelection() {
        return this.jrebelEnabledCheckbox.getSelection();
    }

    public boolean getRemoteServerSupportCheckboxSelection() {
        return this.remoteServerSupportEnabledCheckbox.getSelection();
    }

    private void enableDisableJRebelInteractive(final boolean enable) {
        Job job = new Job("JRebel state change for project: " + this.project.getName()){

            protected IStatus run(IProgressMonitor m) {
                ProjectsGridRow.this.enableDisableJRebel(enable, true, m);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void enableDisableRemoteServerSupportInteractive(final boolean enable) {
        Job job = new Job("JRebel remote server support change for project: " + this.project.getName()){

            protected IStatus run(IProgressMonitor m) {
                ProjectsGridRow.this.enableDisableRemoteServerSupport(enable, true, m);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void enableDisableJRebel(boolean enable, boolean interactive, IProgressMonitor m) {
        if (enable != ProjectHelper.isJRebelProject(this.project)) {
            this.enableDisableJRebelForState(enable, interactive, m);
            EclipseUtil.runInUiThread(() -> this.updateUi(false));
        }
    }

    public void enableDisableRemoteServerSupport(boolean enable, boolean interactive, IProgressMonitor m) {
        if (enable != ProjectHelper.isJRebelRemotingProject(this.project)) {
            this.enableDisableRemoteServerSupportForState(enable, interactive, m);
            EclipseUtil.runInUiThread(() -> this.updateUi(false));
        }
    }

    public void addSelectionChangedListener(SelectionChangeListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangedListener(SelectionChangeListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    private void enableDisableJRebelForState(boolean enable, boolean interactive, IProgressMonitor m) {
        this.setSuccessMessage("");
        if (!enable && ProjectHelper.isJRebelRemotingProject(this.project)) {
            this.enableDisableRemoteServerSupport(enable, false, m);
        }
        try {
            JRebelProject.updateJRebelEnablement(this.project, enable, m);
            this.updateEditButton();
            if (interactive) {
                if (enable) {
                    this.setSuccessMessage("Redeploy project to apply configuration.");
                    consoleLog.info("JRebel enabled for project {}. Redeploy project to apply configuration.", (Object)this.project.getName());
                } else {
                    this.setSuccessMessage("JRebel disabled");
                }
            }
            this.notifySelectionChangeListeners();
        }
        catch (Exception ex) {
            log.warn("Failed to enable/disable JRebel for project: {}", (Object)this.project, (Object)ex);
            this.setErrorMessage(enable ? "Failed to enable JRebel" : "Failed to disable JRebel");
        }
    }

    private void enableDisableRemoteServerSupportForState(boolean enable, boolean interactive, IProgressMonitor m) {
        this.setSuccessMessage("");
        if (enable && !ProjectHelper.isJRebelProject(this.project)) {
            this.enableDisableJRebel(enable, false, m);
        }
        try {
            new RebelRemotingProvider().updateRemotingEnablement(this.project, enable, m);
            this.updateEditButton();
            if (interactive) {
                if (enable) {
                    this.setSuccessMessage("Redeploy project to apply configuration.");
                    consoleLog.info("Remote enabled for project {}. Redeploy project to apply configuration.", (Object)this.project.getName());
                } else {
                    this.setSuccessMessage("Remote server support disabled");
                }
            }
            this.validateServers(enable);
            this.notifySelectionChangeListeners();
        }
        catch (Exception ex) {
            log.error("Failed to enable/disable remote server support for project: {}", (Object)this.project, (Object)ex);
            this.setErrorMessage(enable ? "Failed to enable remote server support" : "Failed to disable remote server support");
        }
    }

    private void onEditClicked() {
        if (ProjectHelper.isJRebelRemotingProject(this.project)) {
            EclipseIdeProject eclipseIdeProject = new EclipseIdeProject(this.project);
            if (IdeRemoting.getInstance().getConfigurations().getRemoteServersForModule((IdeModule)eclipseIdeProject).isEmpty()) {
                boolean actuallyHasWorkspaceServers = !IdeRemoting.getInstance().getConfigurations().getInstanceServers().isEmpty();
                log.debug("Have workspace servers: {}", (Object)actuallyHasWorkspaceServers);
                int dialogResult = new ConfigureRemoteServerPrompt(this.parent, actuallyHasWorkspaceServers).open();
                if (dialogResult == 1025) {
                    this.openProjectRemoteServerSettings(true);
                    this.updateUi();
                } else if (dialogResult == 0) {
                    boolean openDialogAutomatically = IdeRemoting.getInstance().getConfigurations().getInstanceServers().isEmpty();
                    JRebelConfigCenterProxy.openConfigCenterRemoteServersPage(openDialogAutomatically);
                    this.updateUi();
                }
            } else {
                this.openProjectRemoteServerSettings(false);
                this.updateUi();
            }
        } else {
            PreferencesUtil.createPropertyDialogOn((Shell)this.parent.getShell(), (IAdaptable)this.project, (String)"org.zeroturnaround.eclipse.properties.jrebelPropertiesPage", null, null).open();
            this.updateUi();
        }
    }

    private void updateUi() {
        this.updateUi(true);
    }

    private void updateUi(boolean interactive) {
        if (this.parentGotDisposedEvent) {
            log.trace("skipping updateUI - already disposed");
            return;
        }
        if (interactive) {
            this.setSuccessMessage("");
        }
        boolean selectionChanged = false;
        boolean isJRebelProject = ProjectHelper.isJRebelProject(this.project);
        if (isJRebelProject != this.jrebelEnabledCheckbox.getSelection()) {
            selectionChanged = true;
        }
        this.jrebelEnabledCheckbox.setSelection(isJRebelProject);
        boolean isRemoteEnabled = ProjectHelper.isJRebelRemotingProject(this.project);
        if (isRemoteEnabled != this.remoteServerSupportEnabledCheckbox.getSelection()) {
            selectionChanged = true;
        }
        this.remoteServerSupportEnabledCheckbox.setSelection(isRemoteEnabled);
        this.validateServers(isRemoteEnabled);
        if (selectionChanged) {
            this.notifySelectionChangeListeners();
        }
    }

    private void notifySelectionChangeListeners() {
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            try {
                EclipseUtil.runInUiThread(listener::onSelectionChanged);
            }
            catch (Exception e) {
                log.error("Listener throws '{}'", (Object)listener, (Object)e);
            }
        }
    }

    private void validateServers(boolean remoteEnabled) {
        if (remoteEnabled) {
            List servers = IdeRemoting.getInstance().getConfigurations().getRemoteServersForModule((IdeModule)new EclipseIdeProject(this.project));
            if (servers.isEmpty() && IdeRemoting.getInstance().getConfigurations().getInstanceServers().isEmpty()) {
                this.setErrorMessage("Remote server not configured");
            } else if (this.hasAnyMissingUrls(servers)) {
                this.setErrorMessage("Deployment url missing");
            }
        }
    }

    private void updateEditButton() {
        EclipseUtil.runInUiThread(() -> this.editButton.setAsClickableButton(ProjectHelper.isJRebelProject(this.project)));
    }

    private boolean hasAnyMissingUrls(List<RemoteServerConfiguration> servers) {
        for (RemoteServerConfiguration server : servers) {
            if (server.getUrl() != null) continue;
            return true;
        }
        return false;
    }

    private void setSuccessMessage(String text) {
        EclipseUtil.runInUiThread(() -> this.textCell.setSuccessMessage(text));
    }

    private void setErrorMessage(String text) {
        EclipseUtil.runInUiThread(() -> this.textCell.setErrorMessage(text));
    }

    private void openProjectRemoteServerSettings(boolean setModuleSpecificServer) {
        PreferencesUtil.createPropertyDialogOn((Shell)this.parent.getShell(), (IAdaptable)this.project, (String)"org.zeroturnaround.eclipse.properties.jrebelRemoteServerPropertiesPage", null, (Object)(setModuleSpecificServer ? "SelectExplicitServer" : null)).open();
    }

    @Override
    public void setHidden(boolean hidden) {
        Control[] controlArray = new Control[]{this.textCell, this.editButton, this.jrebelEnabledCheckbox, this.remoteServerSupportEnabledCheckbox};
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setVisible(!hidden);
            GridData layoutData = (GridData)control.getLayoutData();
            layoutData.exclude = hidden;
            ++n2;
        }
    }

    static interface SelectionChangeListener {
        public void onSelectionChanged();
    }
}

