/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.projects;

import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModel;
import com.zeroturnaround.jrebel.ide.common.guide.model.GuideModelStep;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.ui.AbstractPage;
import org.zeroturnaround.eclipse.config.ui.IRebelConfigView;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsGrid;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.eclipse.ui.swt.ZtLabel;

public final class ProjectsPage
extends AbstractPage {
    private static final AtomicBoolean redrawOnTabOpen = new AtomicBoolean(false);
    private final Composite mainComposite;

    public ProjectsPage(Composite parent, IRebelConfigView configView) {
        super(parent, 0, configView, "Projects");
        this.mainComposite = this.toolkit.createComposite(this);
        this.createPageContents();
    }

    private void createPageContents() {
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 5;
        this.mainComposite.setLayout((Layout)gridLayout);
        Composite leftColumn = this.toolkit.createComposite(this.mainComposite, 0);
        GridData leftColumnLayoutData = new GridData(4, 4, false, true, 1, 1);
        leftColumnLayoutData.minimumWidth = 650;
        leftColumn.setLayoutData((Object)leftColumnLayoutData);
        this.toolkit.paintBordersFor(leftColumn);
        GridLayout leftColumnGridLayout = new GridLayout(1, false);
        leftColumnGridLayout.verticalSpacing = 10;
        leftColumnGridLayout.marginWidth = 0;
        leftColumn.setLayout((Layout)leftColumnGridLayout);
        this.createContents(leftColumn);
        Composite rightColumn = this.toolkit.createComposite(this.mainComposite, 0);
        GridLayout rightColumnLayout = new GridLayout(1, false);
        rightColumnLayout.marginHeight = 20;
        rightColumnLayout.marginWidth = 20;
        rightColumn.setLayout((Layout)rightColumnLayout);
        GridData rightColumnLayoutData = new GridData(4, 4, true, false, 1, 1);
        rightColumn.setLayoutData((Object)rightColumnLayoutData);
        this.createIntroductionPanel(rightColumn);
        redrawOnTabOpen.set(false);
    }

    private void createContents(Composite outerParent) {
        new BoldLabel(outerParent, "Configure projects and applications for JRebel");
        ScrollBars scrollBars = new ScrollBars(outerParent, 768);
        Composite content = scrollBars.content;
        Composite composite = this.toolkit.createComposite(content);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        new ProjectsGrid(composite);
        this.addStartupSettingsLink(composite);
        scrollBars.contentsChanged();
    }

    private void addStartupSettingsLink(Composite container) {
        Listener listener = event -> {
            this.markProjectConfigCompleted();
            JRebelConfigCenter.openStartup();
        };
        new ZtLabel(container).text("Next \u2192 ").link("review your startup settings.", listener);
    }

    private void markProjectConfigCompleted() {
        if (!GuideModel.getInstance().getMessenger().isDisabledOrComplete()) {
            ((GuideModelStep)GuideModel.getInstance().getGuideModelSteps().get(GuideModel.Step.PROJECT_CONFIGURATION)).markCompleted();
        }
    }

    private void createIntroductionPanel(Composite outerParent) {
        Composite parent = new Composite(outerParent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        GridData gridData = new GridData(131072, 128, true, true, 1, 1);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)gridData);
        parent.setBackground(Display.getCurrent().getSystemColor(22));
        new ZtLabel(parent).bold("Configuring projects with JRebel");
        new ZtLabel(parent).text("Select").image(RebelImage.JREBEL.getImage()).text(" to enable JRebel for the project. This will add").newline().text("the rebel.xml configuration file to the project.");
        new ZtLabel(parent).text("Select").image(RebelImage.JREBEL_CLOUD.getImage()).text(" to enable remote server support for the project.").newline().text("This will add rebel-remote.xml to the project.");
        new ZtLabel(parent).text("Press ").image(RebelImage.EDIT_PENCIL.getImage()).text(" to configure JRebel settings for this project.");
    }

    @Override
    public void updateContent() {
        this.clearContents();
        this.createPageContents();
        this.pack();
    }

    @Override
    public void onTabSelected() {
        if (redrawOnTabOpen.getAndSet(false)) {
            this.updateContent();
        }
    }

    public static void redrawOnOpen() {
        redrawOnTabOpen.set(true);
    }

    private void clearContents() {
        Control[] controlArray = this.mainComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.pack();
    }
}

