/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.startupinstructions;

import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.swt.SWTStartupComponentConverter;
import org.zeroturnaround.eclipse.ui.swt.CustomFormToolkit;
import org.zeroturnaround.eclipse.ui.swt.ScrollBars;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.ide.common.pluto.PlutoInfoContainer;
import org.zeroturnaround.jrebel.ide.common.pluto.PlutoMacro;
import org.zeroturnaround.jrebel.ide.common.pluto.StepParser;

public final class SWTManualPanel
extends Composite {
    private final CustomFormToolkit toolkit = new CustomFormToolkit(Display.getCurrent());
    private final Composite mainComposite;
    private final SWTCustomer customer;
    private final PlutoInfoContainer dataSource;
    private final String preselectedOsName;
    private final Combo comboOS;
    private final Combo comboJDK;
    private final Combo comboServer;
    private final Composite mainPanel;

    public SWTManualPanel(Composite parent, int style, PlutoInfoContainer container, String osName, SWTCustomer customer) {
        super(parent, style);
        this.customer = customer;
        this.dataSource = container;
        this.preselectedOsName = osName;
        this.setBackgroundMode(2);
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.toolkit.adapt(this);
        this.toolkit.paintBordersFor(this);
        this.setLayout((Layout)new FillLayout());
        this.mainComposite = this.toolkit.createComposite(this);
        GridLayout manualPanelLayout = new GridLayout(1, false);
        manualPanelLayout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)manualPanelLayout);
        Composite combosComposite = new Composite(this.mainComposite, 0);
        GridLayout combosLayout = new GridLayout(osName != null ? 2 : 3, true);
        combosLayout.marginWidth = 0;
        combosComposite.setLayout((Layout)combosLayout);
        combosComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.adapt(combosComposite);
        this.toolkit.paintBordersFor(combosComposite);
        this.comboOS = new Combo(combosComposite, 8);
        this.comboOS.setBounds(0, 0, 37, 28);
        this.toolkit.adapt((Composite)this.comboOS);
        this.toolkit.paintBordersFor((Composite)this.comboOS);
        this.comboJDK = new Combo(combosComposite, 8);
        this.comboJDK.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboJDK.setBounds(0, 0, 37, 28);
        this.toolkit.adapt((Composite)this.comboJDK);
        this.toolkit.paintBordersFor((Composite)this.comboJDK);
        this.comboServer = new Combo(combosComposite, 8);
        this.comboServer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboServer.setBounds(0, 0, 37, 28);
        this.toolkit.adapt((Composite)this.comboServer);
        this.toolkit.paintBordersFor((Composite)this.comboServer);
        if (osName != null) {
            this.comboOS.setVisible(false);
            this.comboOS.setEnabled(false);
            GridData gd = new GridData(4, 0x1000000, false, false, 1, 1);
            gd.exclude = true;
            this.comboOS.setLayoutData((Object)gd);
        } else {
            this.comboOS.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        this.comboJDK.add("Select JVM bitness");
        for (String r : this.dataSource.extractUniqueNames(this.dataSource.getRoot(), 1)) {
            this.comboJDK.add(r);
        }
        this.comboJDK.select(0);
        this.comboOS.add("Select remote OS");
        for (String r : this.dataSource.extractUniqueNames(this.dataSource.getRoot(), 3)) {
            this.comboOS.add(r);
        }
        this.comboOS.select(0);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == SWTManualPanel.this.comboServer || e.getSource() == SWTManualPanel.this.comboOS) {
                    SWTManualPanel.this.selectForCurrent();
                } else {
                    SWTManualPanel.this.updateServerList();
                    SWTManualPanel.this.selectForCurrent();
                }
            }
        };
        this.comboJDK.addSelectionListener((SelectionListener)listener);
        this.comboOS.addSelectionListener((SelectionListener)listener);
        this.comboServer.addSelectionListener((SelectionListener)listener);
        this.mainPanel = new Composite(this.mainComposite, 0);
        this.mainPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout instructionsLayout = new GridLayout(1, true);
        instructionsLayout.marginWidth = 0;
        this.mainPanel.setLayout((Layout)instructionsLayout);
        this.doLayout();
    }

    private void selectForCurrent() {
        String selectedOs;
        String string = selectedOs = this.preselectedOsName == null ? this.comboOS.getText() : this.preselectedOsName;
        if ("macOS".equals(selectedOs)) {
            this.comboJDK.select(SWTManualPanel.findIndexOfItem(this.comboJDK, "64-bit JVM"));
            this.comboJDK.setEnabled(false);
            this.updateServerList();
        } else if (!this.comboJDK.isEnabled()) {
            this.comboJDK.setEnabled(true);
        }
        PlutoInfoContainer.Record record = this.dataSource.findForPath(new String[]{this.comboJDK.getText(), this.comboServer.getText(), selectedOs});
        this.fillPanelForRecord(record, selectedOs, this.comboJDK.getText());
    }

    private void fillPanelForRecord(PlutoInfoContainer.Record record, String selectedOs, String selectedJdk) {
        if (this.customer != null) {
            this.customer.beforeSection();
        }
        Control[] controlArray = this.mainPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (record != null) {
            Properties propertiesFromCustomer = this.customer == null ? null : this.customer.getPropertiesFormattedForOS(record, selectedOs);
            Properties props = propertiesFromCustomer == null ? new Properties() : propertiesFromCustomer;
            PlutoMacro[] plutoMacroArray = PlutoMacro.values();
            int n3 = plutoMacroArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PlutoMacro m = plutoMacroArray[n4];
                if (!props.containsKey(m.getName())) {
                    props.setProperty(m.getName(), m.getDefault(selectedOs, selectedJdk));
                }
                ++n4;
            }
            int index = 0;
            if (this.customer != null) {
                Control compo;
                while ((compo = this.customer.onStartOfSection(this.mainPanel, record, ++index)) != null) {
                }
                --index;
            }
            for (PlutoInfoContainer.Record item : record.getRecords()) {
                String textPrefix = "*" + Integer.toString(++index) + ".* ";
                SWTStartupComponentConverter.getInstance().convert(this.mainPanel, item.getParsed(), textPrefix, this.customer != null && this.customer.isDarkTheme(), props);
                for (StepParser.Result r : item.getItems()) {
                    SWTStartupComponentConverter.getInstance().convert(this.mainPanel, r, null, this.customer != null && this.customer.isDarkTheme(), props);
                }
            }
            if (this.customer != null) {
                Control compo;
                while ((compo = this.customer.onEndOfSection(this.mainPanel, record, ++index)) != null) {
                }
            }
        }
        this.doLayout();
    }

    private void doLayout() {
        ScrollBars.contentsChanged(this.mainPanel);
    }

    private void updateServerList() {
        String jdk = this.comboJDK.getText();
        String selection = this.comboServer.getItemCount() > 0 ? this.comboServer.getItem(this.comboServer.getSelectionIndex()) : null;
        this.comboServer.removeAll();
        PlutoInfoContainer.Record rec = this.dataSource.findForPath(new String[]{jdk});
        if (rec != null) {
            int newIndex = 0;
            this.comboServer.add("Select target environment");
            List uniqueServerNames = this.dataSource.extractUniqueNames(rec, 1);
            int i = 0;
            while (i < uniqueServerNames.size()) {
                String serverName = (String)uniqueServerNames.get(i);
                this.comboServer.add(serverName);
                if (serverName.equals(selection) && !jdk.equals("Select JVM bitness")) {
                    newIndex = i + 1;
                }
                ++i;
            }
            this.comboServer.select(newIndex);
        }
    }

    private static int findIndexOfItem(Combo combo, String str) {
        int i = 0;
        while (i < combo.getItemCount()) {
            if (str.equals(combo.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectPath(final String ... items) {
        EclipseUtil.runInUiThread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < items.length) {
                    switch (i) {
                        case 0: {
                            SWTManualPanel.this.comboJDK.select(SWTManualPanel.findIndexOfItem(SWTManualPanel.this.comboJDK, items[i] == null ? "Select JVM bitness" : items[i]));
                            SWTManualPanel.this.updateServerList();
                            SWTManualPanel.this.selectForCurrent();
                            break;
                        }
                        case 1: {
                            SWTManualPanel.this.comboServer.select(SWTManualPanel.findIndexOfItem(SWTManualPanel.this.comboServer, items[i] == null ? "Select target environment" : items[i]));
                            SWTManualPanel.this.selectForCurrent();
                            break;
                        }
                        case 2: {
                            SWTManualPanel.this.comboOS.select(SWTManualPanel.findIndexOfItem(SWTManualPanel.this.comboOS, items[i] == null ? "Select remote OS" : items[i]));
                            SWTManualPanel.this.selectForCurrent();
                            break;
                        }
                    }
                    ++i;
                }
                SWTManualPanel.this.selectForCurrent();
            }
        });
    }

    public static interface SWTCustomer {
        public void beforeSection();

        public Control onStartOfSection(Composite var1, PlutoInfoContainer.Record var2, int var3);

        public Control onEndOfSection(Composite var1, PlutoInfoContainer.Record var2, int var3);

        public boolean isDarkTheme();

        public Properties getPropertiesFormattedForOS(PlutoInfoContainer.Record var1, String var2);
    }
}

