/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.startupinstructions;

import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.config.handlers.JRebelConfigCenter;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.SWTAbstractListPanel;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.SWTManualPanel;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.swt.CodeSnippetPanel;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.swt.StyledLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.ide.common.pluto.PlutoInfoContainer;
import org.zeroturnaround.jrebel.ide.common.pluto.PlutoUtils;

public final class SWTStartupRemotePanel
extends SWTAbstractListPanel {
    private static final PlutoInfoContainer dataSource = new PlutoInfoContainer(PlutoUtils.readResource((String)"manual_remote.txt"));
    private boolean endFlag;
    private boolean startFlag;

    public SWTStartupRemotePanel(Composite parent, int style) {
        super("Use the following startup scripts when running JRebel on a remote server.", parent, style);
        SWTManualPanel mpanel = new SWTManualPanel(this, 0, dataSource, null, this);
        EclipseUtil.runInUiThread(() -> mpanel.selectPath(PlutoUtils.DEFAULT_SELECTION_REMOTE));
    }

    @Override
    public void beforeSection() {
        super.beforeSection();
        this.endFlag = false;
        this.startFlag = false;
    }

    @Override
    public Control onEndOfSection(Composite parent, PlutoInfoContainer.Record record, int itemIndex) {
        if (record == null || record.isFake()) {
            return null;
        }
        if (this.endFlag) {
            return null;
        }
        this.endFlag = true;
        Composite result = new Composite(parent, 0);
        RowLayout rl = new RowLayout(256);
        rl.marginBottom = 30;
        rl.marginHeight = 0;
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginWidth = 0;
        if (EnvironmentUtil.isMac()) {
            rl.spacing = 0;
        }
        result.setLayout((Layout)rl);
        StyledLabel label = new StyledLabel(result, 0, "*" + itemIndex + ".*");
        label.setForeground(parent.getForeground());
        Link link = new Link(result, 0);
        link.setText("Next \u2192 <a>add the remote server to the IDE</a>.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelConfigCenter.openRemoteServers(false);
            }
        });
        return result;
    }

    @Override
    public Control onStartOfSection(Composite parent, PlutoInfoContainer.Record record, int itemIndex) {
        if (record == null || record.isFake()) {
            return null;
        }
        Composite result = null;
        if (this.startFlag) {
            return null;
        }
        this.startFlag = true;
        if (record.getName().equalsIgnoreCase("windows")) {
            result = new Composite(parent, 0);
            RowLayout rl = new RowLayout(256);
            result.setLayout((Layout)rl);
            rl.marginBottom = 0;
            rl.marginHeight = 0;
            rl.marginLeft = 0;
            rl.marginRight = 0;
            rl.marginTop = 0;
            rl.marginWidth = 0;
            if (EnvironmentUtil.isMac()) {
                rl.spacing = 0;
            }
            new StyledLabel(result, 0, "*" + itemIndex + ".*");
            new Label(result, 0).setText("Download and extract JRebel onto the remote server. Download link:");
            new CodeSnippetPanel(parent, 0, this.isDarkTheme(), "https://dl.zeroturnaround.com/jrebel-stable-nosetup.zip", 50);
        }
        return result;
    }

    @Override
    public Properties getPropertiesFormattedForOS(PlutoInfoContainer.Record record, String osName) {
        return PlutoUtils.createPropertiesRemote((String)osName);
    }
}

