/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.startupinstructions.swt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.eclipse.config.util.ClipboardUtil;
import org.zeroturnaround.eclipse.ui.RebelImage;

public final class CodeSnippetPanel
extends Composite {
    private static final String COMMANDS = "ant devmode $JAVA_OPTS -XX: -Xms -Xmx %REBEL_HOME% $JAVA_OPTS %JAVA_OPTS% -javaagent: @echo echo set call export run #!/bin/bash off on if then else java.exe java";
    private static final Pattern COMMANDS_PATTERN;
    private final String rawText;
    private static final int COLOR_BACKGROUND = 0;
    private static final int COLOR_STRING = 1;
    private static final int COLOR_VAR = 2;
    private static final int COLOR_KEYWORD = 3;
    private static final int COLOR_OTHER = 4;
    private static final int[] THEME_LIGHT;
    private static final int[] THEME_DARK;

    static {
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = COMMANDS.split("\\s");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append("\\Q").append(str).append("\\E");
            ++n2;
        }
        COMMANDS_PATTERN = Pattern.compile("(?<=\\b|\\W)?(" + buffer.toString() + ")|[\\\"](.*?)[\\\"]|\\b([^\\s=\\\"\\']+?)\\s*(?=\\=)|([^\\s=\\\"\\']+)");
        THEME_LIGHT = new int[]{0xFFFFFF, 7886217, 4160684, 0x337357, 0x333333};
        THEME_DARK = new int[]{0xACACAE, 7886217, 4160684, 0x337357, 0x333333};
    }

    private Color color(int[] theme, int index) {
        int color = theme[index];
        return new Color((Device)this.getDisplay(), new RGB(color >>> 16, color >>> 8 & 0xFF, color & 0xFF));
    }

    public CodeSnippetPanel(Composite parent, int style, boolean darkTheme, String snippetText, int maxHeight) {
        super(parent, style);
        this.rawText = String.valueOf(snippetText.trim()) + '\n';
        GridLayout layout = new GridLayout(2, false);
        this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        this.setLayout((Layout)layout);
        ScrolledComposite scompo = new ScrolledComposite((Composite)this, 2304);
        scompo.setExpandVertical(true);
        StyledText styledText = new StyledText((Composite)scompo, 10);
        styledText.setLayout((Layout)new FillLayout());
        styledText.setIndent(2);
        scompo.setContent((Control)styledText);
        styledText.setText(this.rawText);
        this.highlight(styledText, darkTheme);
        styledText.pack();
        int styledTextHeight = styledText.getBounds().height;
        GridData stgd = new GridData(4, 0x1000000, true, false, 1, 1);
        stgd.heightHint = Math.min(maxHeight, styledTextHeight);
        scompo.setLayoutData((Object)stgd);
        final Label label = new Label((Composite)this, 0);
        final Image copyBlack = RebelImage.COPY_BLACK.getImage();
        final Image copyGreen = RebelImage.COPY_GREEN.getImage();
        label.setImage(copyBlack);
        label.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        label.setToolTipText("Copy to clipboard");
        label.setCursor(Display.getDefault().getSystemCursor(21));
        label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                label.setImage(copyGreen);
            }

            public void mouseExit(MouseEvent e) {
                label.setImage(copyBlack);
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CodeSnippetPanel.this.doCopy();
            }
        });
    }

    private void setStyle(StyledText p, int start, int length, int[] colorTheme, int colorIndex, boolean bold) {
        StyleRange range = new StyleRange(start, length, this.color(colorTheme, colorIndex), p.getBackground(), bold ? 0 : 1);
        p.setStyleRange(range);
    }

    private void highlight(StyledText p, boolean darkTheme) {
        int[] theme = darkTheme ? THEME_DARK : THEME_LIGHT;
        p.setBackground(this.color(theme, 0));
        Matcher cmd = COMMANDS_PATTERN.matcher(p.getText());
        while (cmd.find()) {
            if (cmd.group(1) != null) {
                this.setStyle(p, cmd.start(1), cmd.end(1) - cmd.start(1), theme, 3, true);
                continue;
            }
            if (cmd.group(2) != null) {
                this.setStyle(p, cmd.start(2), cmd.end(2) - cmd.start(2), theme, 1, false);
                continue;
            }
            if (cmd.group(3) != null) {
                this.setStyle(p, cmd.start(3), cmd.end(3) - cmd.start(3), theme, 2, false);
                continue;
            }
            if (cmd.group(4) == null) continue;
            this.setStyle(p, cmd.start(4), cmd.end(4) - cmd.start(4), theme, 4, false);
        }
    }

    private void doCopy() {
        ClipboardUtil.setTextContents(Display.getDefault(), this.rawText);
    }
}

