/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.startupinstructions.swt;

import java.util.Properties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.swt.CodeSnippetPanel;
import org.zeroturnaround.eclipse.config.ui.startupinstructions.swt.StyledLabel;
import org.zeroturnaround.jrebel.ide.common.pluto.PlutoUtils;
import org.zeroturnaround.jrebel.ide.common.pluto.StepParser;

public class SWTStartupComponentConverter {
    private static final SWTStartupComponentConverter INSTANCE = new SWTStartupComponentConverter();

    public static SWTStartupComponentConverter getInstance() {
        return INSTANCE;
    }

    private static String replaceMacroses(Properties macroses, String text) {
        if (macroses == null) {
            return text;
        }
        String result = text;
        for (String k : macroses.stringPropertyNames()) {
            result = result.replace("${{" + k + "}}", macroses.getProperty(k));
        }
        return result;
    }

    public Control convert(Composite parent, StepParser.Result parserResult, String textPrefix, boolean darkTheme, Properties macroses) {
        if (parserResult == null) {
            return null;
        }
        switch (parserResult.getType()) {
            case LEVEL4: 
            case LEVEL3: 
            case LEVEL2: 
            case LEVEL1: {
                return this.makeHeader(parent, textPrefix, PlutoUtils.processProcSections((String)SWTStartupComponentConverter.replaceMacroses(macroses, parserResult.getText())));
            }
            case CODE: {
                return this.makeForCodeSnippet(parent, PlutoUtils.processProcSections((String)SWTStartupComponentConverter.replaceMacroses(macroses, parserResult.getText())), darkTheme);
            }
            case TEXT: {
                return this.makeForText(parent, textPrefix, PlutoUtils.processProcSections((String)SWTStartupComponentConverter.replaceMacroses(macroses, parserResult.getText())));
            }
        }
        throw new Error("Unexpected type [" + parserResult + ']');
    }

    private Control makeHeader(Composite parent, String prefix, String text) {
        return this.makeForText(parent, prefix, text);
    }

    private Control makeForText(Composite parent, String prefix, String text) {
        StyledLabel label = new StyledLabel(parent, 16, String.valueOf(prefix == null ? "" : prefix) + text);
        label.setLayoutData(new GridData(768));
        label.setForeground(parent.getForeground());
        return label;
    }

    private Control makeForCodeSnippet(Composite parent, String text, boolean darkTheme) {
        CodeSnippetPanel result = new CodeSnippetPanel(parent, 0, darkTheme, text, 250);
        GridData gd = new GridData(4, 1, true, false);
        result.setData(gd);
        return result;
    }
}

