/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.startupinstructions.swt;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class StyledLabel
extends StyledText {
    private static final String lineSeparator = System.getProperty("line.separator", "\r\n");

    public StyledLabel(Composite parent, int style, String startupStyledText) {
        super(parent, style | 0x80000 | 8 | 0x40);
        this.setWordWrap(true);
        this.preprocessAndSetText(startupStyledText);
    }

    public final void setWordWrap(boolean wrap) {
        super.setWordWrap(wrap);
    }

    private void preprocessAndSetText(String startupStyledText) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StringBuilder buffer = new StringBuilder();
        int boldCounter = 0;
        boolean specChars = false;
        StyleRange someRange = null;
        char[] cArray = startupStyledText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (specChars) {
                if (c == '`') {
                    specChars = false;
                } else {
                    buffer.append(c);
                }
            } else {
                switch (c) {
                    case '`': {
                        specChars = true;
                        break;
                    }
                    case '*': {
                        if (boldCounter > 0 && someRange != null) {
                            someRange.length = buffer.length() - someRange.start;
                            styleRanges.add(someRange);
                            someRange = null;
                            --boldCounter;
                            break;
                        }
                        someRange = new StyleRange();
                        someRange.fontStyle = 1;
                        someRange.start = buffer.length();
                        ++boldCounter;
                        break;
                    }
                    case '\n': {
                        buffer.append(lineSeparator);
                        break;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            ++n2;
        }
        this.setText(buffer.toString());
        this.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
    }
}

