/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.widgets;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import com.zeroturnaround.jrebel.remoting.RemotingContext;
import com.zeroturnaround.jrebel.remoting.util.RemoteServersDialogUtil;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.config.ui.projects.ProjectsPage;
import org.zeroturnaround.eclipse.config.ui.widgets.JRebelConfigurationGrid;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedIcon;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextLabel;
import org.zeroturnaround.eclipse.config.ui.widgets.TableRowGrid;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.remoteservers.RemoteServerDialog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class RemoteServerGrid
extends JRebelConfigurationGrid
implements TableRowGrid.RowListner {
    private static final Log log = Log.getInstance(RemoteServerGrid.class);
    public static final String ENABLE_SYNC_TOOLTIP = "Enable JRebel synchronization";
    private final RemoteServerConfigurations remoteServerConfigurations;

    public RemoteServerGrid(Composite parent, RemoteServerConfigurations remoteServerConfigurations) {
        super(parent, 5);
        this.remoteServerConfigurations = remoteServerConfigurations;
        List servers = remoteServerConfigurations.getInstanceServers();
        this.addHeader(this.container, "Server");
        for (RemoteServerConfiguration server : servers) {
            this.addRow(this.container, server);
        }
    }

    private void addHeader(Composite parent, String text) {
        new SpacedIcon(parent, RebelImage.JREBEL_CLOUD.getImage(), 22, ENABLE_SYNC_TOOLTIP);
        new SpacedTextLabel(parent, 22).setText(text);
        new SpacedTextLabel(parent, 22, 100).setText("Status");
        this.addSpacerHeaderCell(parent);
        this.addSpacerHeaderCell(parent);
    }

    private TableRowGrid addRow(Composite parent, RemoteServerConfiguration server) {
        TableRowGrid row = new TableRowGrid(parent, server, ENABLE_SYNC_TOOLTIP);
        row.addListner(this);
        return row;
    }

    @Override
    public void onSyncEnabledSelectionChange(TableRowGrid emitter, boolean selected) {
        this.remoteServerConfigurations.syncEnabledChanged();
    }

    @Override
    public void onDelete(TableRowGrid row) {
        RemoteServerConfiguration server = row.getServer();
        RemoteServersDialogUtil.DeletionConfirmationDisplayer displayer = (title, message) -> MessageDialog.openQuestion((Shell)this.container.getShell(), (String)title, (String)message);
        boolean confirm = RemoteServersDialogUtil.confirmDeletingServer((RemotingContext)IdeRemoting.getInstance(), (RemoteServerConfiguration)server, (boolean)true, (RemoteServersDialogUtil.DeletionConfirmationDisplayer)displayer);
        if (confirm) {
            this.remoteServerConfigurations.deleteServerAndDeconfigureRemoteProjectsWithNoExplicitServers(server);
            ProjectsPage.redrawOnOpen();
        }
    }

    @Override
    public void onEdit(TableRowGrid row) {
        log.trace("RemoteServerGrid.onEdit() " + row.getServer());
        new RemoteServerDialog(this.container.getShell(), row.getServer()).open();
    }
}

