/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.widgets;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SpacedIcon
extends Composite {
    private Label label;
    private final Image image;
    private final MouseListener mouseListener;
    private boolean isListenerAdded;
    private Image disabledImage;

    public SpacedIcon(Composite container, Image icon, int backgroundColorIndex, String tooltip) {
        this(container, icon, backgroundColorIndex, tooltip, null);
    }

    public SpacedIcon(Composite container, Image icon, int backgroundColorIndex, String tooltip, final Runnable onClick) {
        super(container, 0);
        this.setBackground(Display.getCurrent().getSystemColor(backgroundColorIndex));
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginHeight = 1;
        containerLayout.marginWidth = 1;
        this.setLayout((Layout)containerLayout);
        GridData layoutData = new GridData(4, 4, true, false, 1, 1);
        this.setLayoutData(layoutData);
        Composite labelComposite = new Composite((Composite)this, 0);
        labelComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        labelComposite.setLayout((Layout)new GridLayout());
        this.label = new Label(labelComposite, 0);
        this.image = icon;
        this.label.setImage(icon);
        this.label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.label.setToolTipText(tooltip);
        if (onClick != null) {
            this.mouseListener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    onClick.run();
                }
            };
            this.setAsClickableButton(true);
        } else {
            this.mouseListener = null;
        }
    }

    public void setDisabledButtonImage(Image disabledImage) {
        this.disabledImage = disabledImage;
    }

    public void setAsClickableButton(boolean clickable) {
        if (clickable) {
            if (!this.isListenerAdded) {
                this.label.addMouseListener(this.mouseListener);
                this.isListenerAdded = true;
            }
            this.label.setImage(this.image);
            this.setCursor(Display.getCurrent().getSystemCursor(21));
        } else {
            if (this.isListenerAdded) {
                this.label.removeMouseListener(this.mouseListener);
                this.isListenerAdded = false;
            }
            this.label.setImage(this.disabledImage == null ? null : this.disabledImage);
            this.setCursor(null);
        }
        this.layout();
    }
}

