/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.widgets;

import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.common.util.IdeStringUtils;

public final class SpacedTextAndStatusLabel
extends Composite {
    private Label textLabel;
    private Label statusLabel;

    public SpacedTextAndStatusLabel(Composite container) {
        super(container, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginHeight = 1;
        containerLayout.marginWidth = 1;
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setLayout((Layout)containerLayout);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.widthHint = 500;
        this.setLayoutData(layoutData);
        Composite labelsComposite = new Composite((Composite)this, 0);
        labelsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        labelsComposite.setLayout((Layout)new GridLayout(3, false));
        this.textLabel = new Label(labelsComposite, 0);
        this.statusLabel = new Label(labelsComposite, 0);
    }

    public void setText(String text) {
        this.textLabel.setText(IdeStringUtils.ellipsify((String)text));
    }

    public void setSuccessMessage(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(Display.getCurrent().getSystemColor(9));
        this.layout(true, true);
    }

    public void setErrorMessage(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.layout(true, true);
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        SpacedTextAndStatusLabel.addMouseListenerToChildren(this, listener);
    }

    private static void addMouseListenerToChildren(Composite composite, MouseListener listener) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addMouseListener(listener);
            if (control instanceof Composite) {
                SpacedTextAndStatusLabel.addMouseListenerToChildren((Composite)control, listener);
            }
            ++n2;
        }
    }
}

