/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.ui.widgets;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedButton;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedIcon;
import org.zeroturnaround.eclipse.config.ui.widgets.SpacedTextLabel;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.jrebel.client.logger.Log;

public class TableRowGrid {
    private static final Log log = Log.getInstance(TableRowGrid.class);
    private final RemoteServerConfiguration server;
    private SpacedButton syncEnabledCheckbox;
    private ArrayList<RowListner> rowListeners = new ArrayList();

    public TableRowGrid(Composite parent, RemoteServerConfiguration server, String enableSyncTooltip) {
        this.server = server;
        this.syncEnabledCheckbox = new SpacedButton(parent, 32, enableSyncTooltip);
        this.syncEnabledCheckbox.setSelection(server.isSyncEnabled());
        this.syncEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableRowGrid.this.widgetSelected();
            }
        });
        new SpacedTextLabel(parent, 1).setText(server.getNameOrUrl());
        new SpacedTextLabel(parent, 1, 100).setText(server.getStatus().getDescription());
        new SpacedIcon(parent, RebelImage.EDIT_PENCIL.getImage(), 1, "Edit", new Runnable(){

            @Override
            public void run() {
                TableRowGrid.this.onEdit();
            }
        });
        new SpacedIcon(parent, RebelImage.CLOSE.getImage(), 1, "Remove", new Runnable(){

            @Override
            public void run() {
                TableRowGrid.this.onDelete();
            }
        });
    }

    public RemoteServerConfiguration getServer() {
        return this.server;
    }

    protected void widgetSelected() {
        boolean syncEnabled = this.syncEnabledCheckbox.getSelection();
        log.trace("Remote server [" + this.server.getNameOrUrl() + "] sync enabled: " + syncEnabled);
        this.server.setSyncEnabled(syncEnabled);
        for (RowListner rowListner : this.rowListeners) {
            rowListner.onSyncEnabledSelectionChange(this, syncEnabled);
        }
    }

    protected void onDelete() {
        for (RowListner rowListner : this.rowListeners) {
            rowListner.onDelete(this);
        }
    }

    protected void onEdit() {
        for (RowListner rowListner : this.rowListeners) {
            rowListner.onEdit(this);
        }
    }

    public void addListner(RowListner listner) {
        this.rowListeners.add(listner);
    }

    public String toString() {
        return this.server.getNameOrUrl();
    }

    public static interface RowListner {
        public void onSyncEnabledSelectionChange(TableRowGrid var1, boolean var2);

        public void onDelete(TableRowGrid var1);

        public void onEdit(TableRowGrid var1);
    }
}

