/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.config.util;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public abstract class DelayedModifyListener
implements ModifyListener {
    private static final long DELAY = 500L;
    private final Text text;
    private volatile long prevModification = 0L;
    private volatile String prevValue = null;
    private volatile boolean taskScheduled = false;

    public DelayedModifyListener(Text text) {
        this.text = text;
    }

    public void setPrevValue(String prevValue) {
        this.prevValue = prevValue;
    }

    public void modifyText(ModifyEvent e) {
        String curValue = this.text.getText();
        if (this.prevValue == null || !this.prevValue.equals(curValue)) {
            this.prevValue = curValue;
            this.delayedNotifyValueChanged();
        }
    }

    private synchronized void delayedNotifyValueChanged() {
        this.prevModification = System.currentTimeMillis();
        if (!this.taskScheduled) {
            this.taskScheduled = true;
            final Timer timer = new Timer("Delayed Modification Trigger");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (DelayedModifyListener.this.text.isDisposed()) {
                        timer.cancel();
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (now > DelayedModifyListener.this.prevModification + 500L) {
                        final String[] prevValue = new String[1];
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!DelayedModifyListener.this.text.isDisposed()) {
                                    prevValue[0] = DelayedModifyListener.this.text.getText();
                                }
                            }
                        });
                        DelayedModifyListener.this.valueChanged(prevValue[0]);
                        DelayedModifyListener.this.taskScheduled = false;
                        timer.cancel();
                    }
                }
            };
            timer.scheduleAtFixedRate(task, 510L, 510L);
        }
    }

    public abstract void valueChanged(String var1);
}

