/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.debug;

import com.sun.jdi.Mirror;
import com.sun.jdi.VirtualMachineManager;
import com.zeroturnaround.jdi.JRVirtualMachine;
import com.zeroturnaround.jdi.JRWrapper;
import com.zeroturnaround.jdi.exceptionfilter.StaticNotifier;
import com.zeroturnaround.jdi.util.Configuration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.internal.debug.core.hcr.JavaHotCodeReplaceManager;
import org.eclipse.jdt.internal.debug.core.hcr.MethodSearchVisitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.zeroturnaround.eclipse.RebelLog;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.debug.EclipseDebuggerIntegrationConfiguration;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class DebuggerIntegration {
    private static final Log log = Log.getInstance(DebuggerIntegration.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(DebuggerIntegration.class);
    private static final String debugLogName = DebuggerIntegration.lookupDebuggerLogName();

    public static String getTargetLogName() {
        return debugLogName;
    }

    private static String lookupDebuggerLogName() {
        EclipseDebuggerIntegrationConfiguration conf = new EclipseDebuggerIntegrationConfiguration(null);
        return conf.getLogFileName();
    }

    public static void start() {
        IPreferenceStore prefs = RebelPlugin.getDefault().getPreferenceStore();
        DebuggerIntegration.initDebuggerIntegrationListener();
        Configuration.setInstance((Configuration)new EclipseDebuggerIntegrationConfiguration(prefs));
        try {
            VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
            Field f = Bootstrap.class.getDeclaredField("fVirtualMachineManager");
            f.setAccessible(true);
            f.set(Bootstrap.class, JRWrapper.wrap((VirtualMachineManager)vmm));
        }
        catch (Throwable t) {
            log.error(t);
        }
        try {
            DebuggerIntegration.replaceHotCodeReplaceManager();
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    private static void replaceHotCodeReplaceManager() throws Exception {
        ClassLoader cl = JavaHotCodeReplaceManager.class.getClassLoader();
        ClassPool cp = new ClassPool(null);
        cp.appendClassPath((ClassPath)new LoaderClassPath(cl));
        cp.appendClassPath((ClassPath)new ClassClassPath(Mirror.class));
        cp.importPackage("java.util");
        cp.importPackage("java.lang.reflect");
        cp.importPackage("org.eclipse.jdt.internal.debug.core");
        cp.importPackage("org.eclipse.jdt.internal.debug.core.breakpoints");
        String origName = JavaHotCodeReplaceManager.class.getName();
        String newName = DebuggerIntegration.replaceHotRelaceClassName(origName);
        CtClass ctClass = cp.getAndRename(origName, newName);
        DebuggerIntegration.instrumentGetAffectedFrameMethod(cp, ctClass);
        DebuggerIntegration.instrumentRedefineTypesJdkMethod(cp, ctClass);
        Class<MethodSearchVisitor> neighbourClass = MethodSearchVisitor.class;
        CtClass[] ctClassArray = cp.get(origName).getNestedClasses();
        int n = ctClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtClass inner = ctClassArray[n2];
            String origInnerName = inner.getName();
            String newInnerName = DebuggerIntegration.replaceHotRelaceClassName(origInnerName);
            ctClass.replaceClassName(origInnerName, newInnerName);
            CtClass ctInner = cp.getAndRename(origInnerName, newInnerName);
            ctInner.replaceClassName(origName, newName);
            cp.toClass(ctInner, neighbourClass, cl, null);
            ++n2;
        }
        JavaHotCodeReplaceManager.getDefault().shutdown();
        Class c = cp.toClass(ctClass, neighbourClass, cl, null);
        Method getDefault = c.getDeclaredMethod("getDefault", new Class[0]);
        Method startup = c.getDeclaredMethod("startup", new Class[0]);
        startup.invoke(getDefault.invoke(null, new Object[0]), new Object[0]);
    }

    private static void instrumentRedefineTypesJdkMethod(ClassPool cp, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod m = ctClass.getDeclaredMethod("redefineTypesJDK", cp.get(new String[]{"org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget", "java.util.List", "java.util.List"}));
        m.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                String methodName = m.getMethodName();
                if ("reinstallBreakpointsIn".equals(methodName)) {
                    m.replace("$proceed($$);EventDispatcher eventDispatcher = $0.getEventDispatcher();Field fEventHandlers = eventDispatcher.getClass().getDeclaredField(\"fEventHandlers\");fEventHandlers.setAccessible(true);Map eventHandlers = (Map) fEventHandlers.get(eventDispatcher);Method getRequestsMethod = JavaBreakpoint.class.getDeclaredMethod(\"getRequests\", new Class[]{org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget.class});getRequestsMethod.setAccessible(true);for (java.util.Iterator iter = eventHandlers.entrySet().iterator(); iter.hasNext(); ) {  java.util.Map.Entry entry = (java.util.Map.Entry) iter.next();  if (entry.getValue() instanceof JavaBreakpoint) {    List requests = getRequestsMethod.invoke(entry.getValue(), new Object[]{$0});    if (!requests.contains(entry.getKey())) {      requests.add(entry.getKey());    }  }}");
                }
            }
        });
    }

    private static void instrumentGetAffectedFrameMethod(ClassPool cp, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod m = ctClass.getDeclaredMethod("getAffectedFrame", cp.get(new String[]{"org.eclipse.jdt.internal.debug.core.model.JDIThread", "java.util.List"}));
        m.addLocalVariable("shouldReverseFrames", CtClass.booleanType);
        m.insertBefore("shouldReverseFrames = $1.getUnderlyingThread().virtualMachine().getClass().getName().contains(\"$$\");");
        m.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                String methodName = m.getMethodName();
                if ("computeStackFrames".equals(methodName)) {
                    m.replace("$_ = new ArrayList($proceed($$));");
                } else if ("get".equals(methodName)) {
                    m.replace("if ($1 == 0 && $0 == frames && shouldReverseFrames) {  Collections.reverse($0);}shouldReverseFrames = false;$_ = $proceed($$);");
                }
            }
        });
    }

    private static String replaceHotRelaceClassName(String origName) {
        return origName.replace("JavaHotCodeReplaceManager", "RebelHotCodeReplaceManager");
    }

    private static void initDebuggerIntegrationListener() {
        StaticNotifier.addListener((StaticNotifier.Listener)new StaticNotifier.Listener(){
            final Log dlLog = Log.getInstance(StaticNotifier.Listener.class);

            public void onDebuggerIntegrationEvent(StaticNotifier.Event e, Object ... params) {
                switch (e) {
                    case ATTACHED: {
                        this.dlLog.info("Debugger Integration has been attached to the debug vm, jrebel enabled=" + JRebel.isConfigured() + ".");
                        if (params.length == 1 && params[0] instanceof JRVirtualMachine) break;
                        this.dlLog.warn("JRVirtualMachine is not detected [" + (params.length > 0 ? params[0] : "") + ']');
                        break;
                    }
                    case CANT_ATTACH: {
                        if (JRebel.isConfigured()) {
                            Throwable ex = (Throwable)(params != null && params.length == 2 && params[1] instanceof Throwable ? params[1] : null);
                            if (ex != null) {
                                this.dlLog.error("Detected exception during Debugger Integration attachment", ex);
                                RebelLog.eclipseError("JRebel Debugger Integration error. The Integration has been turned off! Restart the debug session!", ex);
                            }
                            consoleLog.error("An error occurred while attaching the JRebel debugger integration. Debugger might not work properly. Send us your logs via Help > JRebel > Submit a Support Ticket.");
                            ConsoleLog.open();
                            break;
                        }
                        this.dlLog.warn("JRebel is not configured");
                        break;
                    }
                }
            }
        });
    }
}

