/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.dialog;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.support.CancelFlagProvider;
import org.zeroturnaround.jrebel.ide.common.support.SupportDataSender;
import org.zeroturnaround.jrebel.ide.common.support.SupportFormData;
import org.zeroturnaround.jrebel.ide.common.support.SupportFormInfoProvider;

public class EclipseSupportFormInfoProvider
extends SupportFormInfoProvider {
    private static final Log log = Log.getInstance(EclipseSupportFormInfoProvider.class);

    public void sendSupportTicket(final SupportFormData supportFormData) {
        EclipseSupportFormInfoProvider.storeComment((String)supportFormData.getComment());
        EclipseSupportFormInfoProvider.storeEmail((String)supportFormData.getEmail());
        Job job = new Job("Sending info to JRebel Support"){

            protected IStatus run(final IProgressMonitor monitor) {
                CancelFlagProvider cancelFlagProvider = () -> ((IProgressMonitor)monitor).isCanceled();
                SupportDataSender.StageListener stageListener = new SupportDataSender.StageListener(){

                    public void onStageChanged(SupportDataSender sender, SupportDataSender.Stage stage, String note) {
                        switch (stage) {
                            case INIT: {
                                monitor.beginTask("Starting", 3);
                                break;
                            }
                            case PACK: {
                                monitor.setTaskName("Packing");
                                monitor.worked(1);
                                break;
                            }
                            case SEND: {
                                monitor.setTaskName("Sending");
                                monitor.worked(1);
                                break;
                            }
                            case COMPLETED: {
                                monitor.setTaskName("Finishing");
                                this.finishJob(Status.OK_STATUS);
                                break;
                            }
                            case ERROR: {
                                monitor.setTaskName("Error");
                                this.finishJob(Status.CANCEL_STATUS);
                                break;
                            }
                            case CANCELED: {
                                monitor.setTaskName("Cancel");
                                this.finishJob(Status.CANCEL_STATUS);
                                break;
                            }
                            default: {
                                log.warn("Unexpected stage " + stage + ", finishing progressmonitor", new Throwable());
                                this.finishJob(Status.CANCEL_STATUS);
                            }
                        }
                    }
                };
                SupportDataSender sender = new SupportDataSender(cancelFlagProvider, supportFormData, stageListener, SupportDataSender.IDE.ECLIPSE);
                try {
                    sender.syncPackAndSend();
                }
                catch (Exception e) {
                    log.error("Failed to send logs to support", (Throwable)e);
                }
                return Job.ASYNC_FINISH;
            }

            private void finishJob(IStatus status) {
                this.done(status);
                if (Status.OK_STATUS.equals(status)) {
                    EclipseSupportFormInfoProvider.storeComment(null);
                }
            }
        };
        job.schedule();
    }

    public String getTooltipHowToChangeLogLevel() {
        return "You can change the JRebel agent log level from Help > JRebel > Configuration > Advanced.";
    }

    protected String getIdeDebuggerLogName() {
        return "jrebel-eclipse-debugger.log";
    }
}

