/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.dialog;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableState;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelAutoEnableDialog
extends MessageDialog {
    private static final Log log = Log.getInstance(JRebelAutoEnableDialog.class);
    private static final String TITLE = "Enable JRebel for projects?";
    private static final String MESSAGE_PROJECT_LINE = "Would you like to enable JRebel for projects created or imported?";
    private static final String MESSAGE_WORKSPACE_LINE = "Would you like to enable JRebel for workspace projects?";
    private static final String MESSAGE_COMMON_LINE = "\n\nThis will generate and store a rebel.xml configuration file.\nYou can change project settings later from Help > JRebel > Configuration > Projects.";
    private static final String[] DIALOG_BUTTON_LABELS = new String[]{"Enable", "Skip"};
    private final boolean requiresSaving;
    private boolean rememberMyChoiceSelected = false;
    public static DialogOpener dialogOpener = new DialogOpener(){

        @Override
        public int open(MessageDialog dialog) {
            return dialog.open();
        }
    };

    public JRebelAutoEnableDialog(Shell parentShell, String firstLine, boolean requiresSaving) {
        super(parentShell, TITLE, RebelImage.JREBEL.getImage(), String.valueOf(firstLine) + MESSAGE_COMMON_LINE, 0, DIALOG_BUTTON_LABELS, -1);
        this.requiresSaving = requiresSaving;
    }

    public static void askForWorkspace(Shell parent, DialogResultCallback callback) {
        JRebelAutoEnableDialog dialog = new JRebelAutoEnableDialog(parent, MESSAGE_WORKSPACE_LINE, false);
        callback.dialogClosed(JRebelAutoEnableDialog.isPositiveAnswer(dialogOpener.open(dialog)));
    }

    public static void askForNewProject(Shell parent, DialogResultCallback callback) {
        AutoEnableState state = AutoEnableState.fromConfig();
        log.debug("Saved dialog answer state: {}", (Object)state);
        switch (state) {
            case NEVER: {
                callback.dialogClosed(false);
                break;
            }
            case ALWAYS: {
                callback.dialogClosed(true);
                break;
            }
            default: {
                callback.dialogClosed(JRebelAutoEnableDialog.getAnswerAndSaveIfNeeded(parent));
            }
        }
    }

    private static boolean getAnswerAndSaveIfNeeded(Shell parent) {
        JRebelAutoEnableDialog dialog = new JRebelAutoEnableDialog(parent, MESSAGE_PROJECT_LINE, true);
        boolean answer = JRebelAutoEnableDialog.isPositiveAnswer(dialogOpener.open(dialog));
        if (dialog.rememberMyChoiceSelected) {
            log.debug("Save dialog answer: {}", (Object)answer);
            if (answer) {
                AutoEnableState.ALWAYS.save();
            } else {
                AutoEnableState.NEVER.save();
            }
        }
        return answer;
    }

    private static boolean isPositiveAnswer(int ret) {
        return ret == 0;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)gridLayout);
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btn = new Button(buttonBar, 32);
        btn.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        btn.setText("Remember my choice (don't ask again)");
        btn.setFont(parent.getFont());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelAutoEnableDialog.this.rememberMyChoiceSelected = ((Button)e.widget).getSelection();
            }
        });
        btn.setVisible(this.requiresSaving);
        Composite buttons = new Composite(buttonBar, 0);
        GridLayout buttonsLayout = new GridLayout(0, true);
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsLayout);
        GridData buttonsCompositeLayoutData = new GridData(0x1000008, 0x1000000, true, false, 1, 1);
        buttons.setLayoutData((Object)buttonsCompositeLayoutData);
        buttons.setFont(parent.getFont());
        this.createButtonsForButtonBar(buttons);
        return buttonBar;
    }

    public static interface DialogOpener {
        public int open(MessageDialog var1);
    }

    public static interface DialogResultCallback {
        public void dialogClosed(boolean var1);
    }
}

