/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.dialog;

import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.zeroturnaround.eclipse.dialog.EclipseSupportFormInfoProvider;
import org.zeroturnaround.eclipse.preferences.JRebelConfigCenterProxy;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.config.LogLevel;
import org.zeroturnaround.jrebel.ide.common.notifications.SupportDialogOnboardingNotifier;
import org.zeroturnaround.jrebel.ide.common.support.SupportFormData;
import org.zeroturnaround.jrebel.ide.common.support.SupportFormInfoProvider;

public class JRebelSupportDialog
extends Dialog {
    private static final int DIALOG_WIDTH = 700;
    private final EclipseSupportFormInfoProvider infoProvider = new EclipseSupportFormInfoProvider();
    private Text commentArea;
    private Text emailField;
    private Composite errorArea;
    private Label errorInfoField;
    private Button canSendLogsButton;
    private File[] logFiles;
    private static final String MESSAGE_INVALID_EMAIL = "Invalid email address.";
    private static final String MESSAGE_EMPTY_EMAIL = "Email address is required.";
    private static final String MESSAGE_EMPTY_COMMENT = "Please describe your issue.";

    public JRebelSupportDialog(Shell parentShell) {
        super(parentShell);
        SupportDialogOnboardingNotifier.recordSupportDialogOpened();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setImage(RebelImage.JREBEL.getImage());
        newShell.setText("Submit a Support Ticket");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Send", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.commentArea.getText().trim().isEmpty()) {
            this.showError(MESSAGE_EMPTY_COMMENT);
            this.commentArea.setFocus();
            return;
        }
        if (!this.infoProvider.isLicenseEmailAvailable()) {
            if (this.emailField.getText().trim().isEmpty()) {
                this.showError(MESSAGE_EMPTY_EMAIL);
                this.emailField.setFocus();
                return;
            }
            if (!EmailValidator.getInstance().isValid(this.emailField.getText())) {
                this.showError(MESSAGE_INVALID_EMAIL);
                this.emailField.setFocus();
                return;
            }
        }
        this.showError(null);
        String email = this.infoProvider.isLicenseEmailAvailable() ? this.infoProvider.getEmail() : this.emailField.getText();
        this.infoProvider.sendSupportTicket(new SupportFormData(this.commentArea.getText().trim(), email, this.canSendLogsButton.getSelection() ? this.logFiles : new File[]{}));
        this.setReturnCode(0);
        this.close();
    }

    private void showError(String text) {
        boolean show = text != null;
        this.errorInfoField.setText(text == null ? "" : text);
        this.errorInfoField.pack(true);
        this.errorArea.setVisible(show);
        GridData data = (GridData)this.errorArea.getLayoutData();
        data.exclude = !show;
        this.getShell().pack();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = this.createCompositeBody(parent);
        this.createTitleArea(area);
        this.createErrorArea(area);
        this.createDescriptonArea(area);
        this.createLogDescriptionArea(area);
        this.createCommentArea(area);
        this.createEmailArea(area);
        this.createLogInfoArea(area);
        this.addModifyListeners();
        return area;
    }

    private Composite createCompositeBody(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridData containerLayoutData = new GridData(4, 4, true, true);
        area.setLayoutData((Object)containerLayoutData);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginTop = 20;
        containerLayout.marginLeft = 20;
        containerLayout.marginRight = 20;
        area.setLayout((Layout)containerLayout);
        return area;
    }

    private void createErrorArea(Composite parent) {
        this.errorArea = this.createSegmentedGridContainer(parent, 2);
        new Label(this.errorArea, 0).setImage(RebelImage.MESSAGE_ERROR.getImage());
        this.errorInfoField = new Label(this.errorArea, 0);
        this.errorInfoField.setForeground(new Color((Device)Display.getCurrent(), 255, 0, 0));
        GridData data = (GridData)this.errorArea.getLayoutData();
        data.exclude = true;
        this.errorArea.setVisible(false);
    }

    private void createTitleArea(Composite parent) {
        Composite container = this.createSegmentedGridContainer(parent, 1);
        Label label = new Label(container, 0);
        label.setText("Submit a Support Ticket");
        SWTUtil.setFontStyle((Control)label, 1);
        SWTUtil.setFontSize((Control)label, 180);
    }

    private void createDescriptonArea(Composite parent) {
        Composite container = this.createSegmentedGridContainer(parent, 1);
        Label label = new Label(container, 64);
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.widthHint = 600;
        label.setLayoutData((Object)layoutData);
        label.setText("Describe your problem for JRebel support. Provide details on what you were working on, how the issue occurred and what you expected to happen.");
    }

    private void createCommentArea(Composite parent) {
        Composite container = this.createSegmentedGridContainer(parent, 2, true);
        Label label = new Label(container, 0);
        label.setText("Description");
        label.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.commentArea = new Text(container, 2626);
        this.commentArea.setTextLimit(this.infoProvider.getMaxCommentLength());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.commentArea.getLineHeight() * 14;
        layoutData.horizontalIndent = 14;
        this.setFixedWidthLayout((Control)this.commentArea, layoutData);
        this.commentArea.setLayoutData((Object)layoutData);
        this.commentArea.setText(this.infoProvider.getCommentText());
        this.commentArea.setSelection(this.commentArea.getText().length());
        this.commentArea.setTopIndex(this.commentArea.getLineCount() - 1);
        this.commentArea.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
    }

    private void setFixedWidthLayout(Control composite, final GridData gridData) {
        composite.setLayoutData((Object)gridData);
        final int width = composite.getSize().x;
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                gridData.widthHint = width;
            }
        });
    }

    private void createEmailArea(Composite parent) {
        Composite container = this.createSegmentedGridContainer(parent, 3);
        Label label = new Label(container, 0);
        label.setText("Your email");
        label.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.emailField = new Text(container, 2048);
        this.emailField.setText(this.infoProvider.getEmail());
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.horizontalIndent = 18;
        layoutData.widthHint = 300;
        this.emailField.setLayoutData((Object)layoutData);
        this.emailField.setTextLimit(this.infoProvider.getMaxEmailLength());
        if (this.infoProvider.isLicenseEmailAvailable()) {
            container.setVisible(false);
            ((GridData)container.getLayoutData()).exclude = true;
        }
    }

    private void createLogInfoArea(Composite parent) {
        Composite container = this.createSegmentedGridContainer(parent, 2);
        this.canSendLogsButton = new Button(container, 32);
        this.canSendLogsButton.setText("Add logs");
        this.canSendLogsButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 2816);
        scrolledComposite.setLayout((Layout)new GridLayout());
        GridData scld = new GridData(4, 4, true, false);
        scld.heightHint = 105;
        scrolledComposite.setLayoutData((Object)scld);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        final Composite logsListContainer = this.createSegmentedGridContainer((Composite)scrolledComposite, 1);
        scrolledComposite.setContent((Control)logsListContainer);
        new Label(container, 0);
        final Button addOtherLogFilesButton = new Button(container, 8);
        addOtherLogFilesButton.setText("Add other logs...");
        addOtherLogFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelSupportDialog.this.addOtherLogFilesButtonSelected(logsListContainer);
            }
        });
        File[] fileArray = this.logFiles = this.infoProvider.getLogFiles();
        int n = this.logFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addLogFileLink(logsListContainer, file);
            ++n2;
        }
        this.canSendLogsButton.setSelection(this.logFiles.length != 0);
        addOtherLogFilesButton.setEnabled(this.canSendLogsButton.getSelection());
        this.canSendLogsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                addOtherLogFilesButton.setEnabled(JRebelSupportDialog.this.canSendLogsButton.getSelection());
            }
        });
    }

    private void addLogFileLink(Composite logsListContainer, final File file) {
        Link link = new Link(logsListContainer, 0);
        link.setText("<a>" + file.getName() + "</a> (" + this.infoProvider.getHumanReadableSize(file) + ")");
        link.setToolTipText(file.getAbsolutePath());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)file.getAbsolutePath());
            }
        });
    }

    private void createLogDescriptionArea(Composite parent) {
        if (LogLevel.TRACE.equals(JRebelConfiguration.getDefault().logLevel().getValueOrDefault())) {
            return;
        }
        Composite container = this.createSegmentedGridContainer(parent, 2);
        Image image = RebelImage.MESSAGE_INFO.getImage();
        new Label(container, 0).setImage(image);
        int imageWidth = image.getImageData().width;
        int spaceBetweenIconAndLink = 10;
        Link link = new Link(container, 0);
        ((GridLayout)container.getLayout()).horizontalSpacing = spaceBetweenIconAndLink;
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        layoutData.widthHint = 600 - imageWidth - spaceBetweenIconAndLink;
        link.setLayoutData((Object)layoutData);
        String string = "JRebel Agent log level is set to " + this.infoProvider.getCurrentJRebelLogLevel() + ". Consider <a>enabling " + "trace level log</a> to provide our engineers with more data. Reproduce the issue to generate new logs.";
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelSupportDialog.this.closeAndStoreContent();
                JRebelConfigCenterProxy.openConfigCenterAdvancedPage();
            }
        });
        link.setText(string);
        link.setToolTipText(this.infoProvider.getTooltipHowToChangeLogLevel());
    }

    private void closeAndStoreContent() {
        SupportFormInfoProvider.storeComment((String)this.commentArea.getText());
        if (!this.infoProvider.isLicenseEmailAvailable()) {
            SupportFormInfoProvider.storeEmail((String)this.emailField.getText());
        }
        this.close();
    }

    private void onCommentTextChange() {
        if (this.errorArea.isVisible()) {
            this.showError(null);
        }
    }

    private void onEmailTextChange() {
        if (this.errorArea.isVisible()) {
            this.showError(null);
        }
    }

    private Composite createSegmentedGridContainer(Composite parent, int size) {
        return this.createSegmentedGridContainer(parent, size, false);
    }

    private Composite createSegmentedGridContainer(Composite parent, int size, boolean fillVertical) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, fillVertical ? 4 : 0x1000000, true, fillVertical));
        GridLayout containerLayout = new GridLayout(size, false);
        container.setLayout((Layout)containerLayout);
        return container;
    }

    private void addModifyListeners() {
        this.commentArea.addModifyListener(e -> this.onCommentTextChange());
        this.emailField.addModifyListener(e -> this.onEmailTextChange());
    }

    private void addOtherLogFilesButtonSelected(Composite logsListContainer) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.log", "*.*"});
        fileDialog.setFilterNames(new String[]{"Log files (*.log)", "All files (*.*)"});
        String newFile = fileDialog.open();
        if (newFile == null) {
            return;
        }
        File file = new File(newFile);
        if (ArrayUtils.contains((Object[])this.logFiles, (Object)file)) {
            return;
        }
        this.logFiles = (File[])ArrayUtils.add((Object[])this.logFiles, (Object)file);
        this.addLogFileLink(logsListContainer, file);
        ScrolledComposite scrolledComposite = (ScrolledComposite)logsListContainer.getParent();
        scrolledComposite.layout(true, true);
        scrolledComposite.setMinSize(logsListContainer.computeSize(-1, -1));
        scrolledComposite.setOrigin(0, logsListContainer.getClientArea().height);
    }
}

