/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.dialog;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.common.options.Option;
import org.zeroturnaround.common.options.TurnaroundTimeSliderOption;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;

public class TimeSavedDialog
extends MessageDialog {
    private static final String[] DIALOG_BUTTON_LABELS = new String[]{"Save", "Cancel"};
    private static final String TITLE = "JRebel time savings";
    private static final String MESSAGE = "How long does your build + redeploy take without JRebel?";
    private Label text;
    private Scale scale;

    private TimeSavedDialog(Shell parentShell) {
        super(parentShell, TITLE, RebelImage.JREBEL.getImage(), null, 0, DIALOG_BUTTON_LABELS, -1);
    }

    public static boolean open(Shell parent) {
        TimeSavedDialog dialog = new TimeSavedDialog(parent);
        int button = dialog.open();
        return button == 0;
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = this.createCompositeBody(parent);
        Label message = new Label(area, 0);
        message.setText(MESSAGE);
        SWTUtil.setFontStyle((Control)message, 1);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gridLayout = new GridLayout(9, true);
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTimeLabels(composite);
        this.scale = new Scale(composite, 0);
        this.scale.setPageIncrement(30);
        this.scale.setMaximum(240);
        this.scale.setLayoutData((Object)new GridData(4, 128, true, false, 9, 1));
        this.scale.setSelection(this.toScaleValue((Integer)this.getAvgRedeployTimeOption().getValue()));
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeSavedDialog.this.updateText();
            }
        });
        this.text = new Label(area, 0);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.updateText();
        return area;
    }

    protected void buttonPressed(int code) {
        if (code == 0) {
            this.getAvgRedeployTimeOption().setValue((Object)this.fromScaleValue(this.scale.getSelection()));
        }
        super.buttonPressed(code);
    }

    private Option<Integer> getAvgRedeployTimeOption() {
        return JRebelConfiguration.getDefault().avgRedeployTime();
    }

    private void updateText() {
        int scaleValue = this.scale.getSelection();
        int seconds = this.fromScaleValue(scaleValue);
        this.text.setText(String.format("Build and redeploy time %s.", TurnaroundTimeSliderOption.asText((int)seconds)));
    }

    private int toScaleValue(int seconds) {
        return TurnaroundTimeSliderOption.secondsToScale((int)seconds);
    }

    private int fromScaleValue(int scaleValue) {
        return TurnaroundTimeSliderOption.scaleToSeconds((int)scaleValue);
    }

    private Composite createCompositeBody(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridData containerLayoutData = new GridData(4, 4, true, true);
        containerLayoutData.minimumWidth = 500;
        area.setLayoutData((Object)containerLayoutData);
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginTop = 10;
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        containerLayout.verticalSpacing = 20;
        area.setLayout((Layout)containerLayout);
        return area;
    }

    private void createTimeLabels(Composite composite) {
        String[] times;
        String[] stringArray = times = new String[]{"1s", "30s", "1min", "2min", "3min", "5min", "15min", "30min", "1h"};
        int n = times.length;
        int n2 = 0;
        while (n2 < n) {
            String time = stringArray[n2];
            Label label = new Label(composite, 0);
            label.setText(time);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            ++n2;
        }
    }
}

