/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.hybris;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.eclipse.jrebel.EclipseJRebelClientAdapter;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;
import org.zeroturnaround.jrebel.client.startup.SharedScheduler;
import org.zeroturnaround.jrebel.ide.common.framework.hybris.HybrisDetectionUtil;
import org.zeroturnaround.jrebel.ide.common.framework.hybris.HybrisRebelXmlExclusionNotifier;

public class HybrisDetectionFeature {
    private static final Log log = Log.getInstance(HybrisDetectionFeature.class);
    private final IResourceChangeListener listener = this.createHybrisListener();

    public void startHybrisRebelXmlExclusionDetection() {
        log.trace("Add hybris detector project listener");
        SharedScheduler.getExecutor().schedule(this::checkForExistingProjects, 10L, TimeUnit.SECONDS);
    }

    private void checkForExistingProjects() {
        ArrayList<IPath> rootFolders = new ArrayList<IPath>();
        IProject[] iProjectArray = EclipseUtil.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                rootFolders.add(project.getLocation());
            }
            ++n2;
        }
        this.runHybrisCheckForFolders(rootFolders);
    }

    private IResourceChangeListener createHybrisListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IResourceDelta rootDelta = event.getDelta();
                final ArrayList foldersToCheck = new ArrayList();
                try {
                    rootDelta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            int type = resource.getType();
                            if (type == 8) {
                                return true;
                            }
                            if (HybrisDetectionFeature.this.projectAdded(delta) || HybrisDetectionFeature.this.projectOpened(delta) || HybrisDetectionFeature.this.projectHasFoldersAddedToRoot(delta)) {
                                foldersToCheck.add(resource.getLocation());
                            }
                            return false;
                        }
                    });
                }
                catch (CoreException e) {
                    log.warn((Throwable)e);
                }
                HybrisDetectionFeature.this.runHybrisCheckForFolders(foldersToCheck);
            }
        };
    }

    private boolean projectAdded(IResourceDelta delta) {
        IResource resource = delta.getResource();
        return resource.getType() == 4 && delta.getKind() == 1;
    }

    private boolean projectOpened(IResourceDelta delta) {
        IResource resource = delta.getResource();
        return resource.getType() == 4 && delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && resource.getProject().isOpen();
    }

    private boolean projectHasFoldersAddedToRoot(IResourceDelta delta) {
        if (delta.getResource().getType() == 4 && delta.getKind() == 4) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(2);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                if (childDelta.getResource().getType() == 2 && childDelta.getKind() == 1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void runHybrisCheckForFolders(final List<IPath> pathsToCheck) {
        if (pathsToCheck.isEmpty()) {
            return;
        }
        Job job = new Job("JRebel: Scanning for Hybris projects"){

            protected IStatus run(IProgressMonitor monitor) {
                log.trace("run Hybris check in {} folders: {}", (Object)pathsToCheck.size(), (Object)pathsToCheck);
                for (IPath path : pathsToCheck) {
                    try {
                        if (!HybrisDetectionUtil.isHybrisModuleWithRebelXmlExcluded((HybrisDetectionUtil.IoWrapper)HybrisDetectionUtil.IO_FILE, (Object)path.toFile().getAbsoluteFile(), (ProgressMonitor)EclipseJRebelClientAdapter.wrapMonitor(monitor))) continue;
                        HybrisRebelXmlExclusionNotifier.showNotificationAndConsoleLog();
                        EclipseUtil.getWorkspace().removeResourceChangeListener(HybrisDetectionFeature.this.listener);
                        break;
                    }
                    catch (Exception e) {
                        log.debug("Failed to check {} because of {}", (Object)path, (Object)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

