/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel;

import com.zeroturnaround.http.ProxyProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.config.components.PreferenceConfiguration;
import org.zeroturnaround.eclipse.config.model.ProjectModel;
import org.zeroturnaround.eclipse.jrebel.ExternalJRebel;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.enable.AutoEnableNatureMetrics;
import org.zeroturnaround.eclipse.nature.rebelconf.RebelXmlGenerationMetrics;
import org.zeroturnaround.eclipse.preferences.PreferenceReader;
import org.zeroturnaround.eclipse.proxy.EclipseProxyProvider;
import org.zeroturnaround.eclipse.util.EclipseMetricsUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.feature.external.SharedRebelXmlGenerationMetrics;
import org.zeroturnaround.jrebel.client.spi.JRebelClientSettings;
import org.zeroturnaround.jrebel.client.spi.Product;

public class EclipseJRebelClientSettings
extends JRebelClientSettings {
    private static final boolean NOTIFICATIONS_DISABLED_ECLIPSE = Boolean.getBoolean("rebel.ide.eclipse.disable-notifications");
    private static JRebelClientSettings instance;

    public static synchronized JRebelClientSettings getInstance() {
        if (instance == null) {
            instance = new EclipseJRebelClientSettings();
        }
        return instance;
    }

    public String getCoreVersion() {
        return JRebel.getDefault().getVersionString();
    }

    public String getIdePluginVersion() {
        return PlatformInfo.getTrimmedJRebelPluginVersionForRelease();
    }

    @NotNull
    public String getIdeName() {
        return "eclipse";
    }

    public String getIdeProduct() {
        return PlatformInfo.getProductNameArgValue();
    }

    public String getIdeVersion() {
        return PlatformInfo.getVersion();
    }

    public String getIdePlatformVersion() {
        return PlatformInfo.getPlatformVersion();
    }

    public ProxyProvider getProxyProvider() {
        return EclipseProxyProvider.getInstance();
    }

    @NotNull
    public Product getProduct() {
        return Product.ECLIPSE;
    }

    public boolean isNotificationsEnabled() {
        return super.isNotificationsEnabled() && !NOTIFICATIONS_DISABLED_ECLIPSE;
    }

    public Integer getJavaProjectsCount() {
        return EclipseUtil.getWorkspaceJavaProjectsCount();
    }

    public Integer getJavaServersCount() {
        return EclipseUtil.getWorkspaceServersCount();
    }

    protected void switchJRebelClientToGriffinImpl() {
        PreferenceConfiguration preferenceConfiguration = new PreferenceConfiguration();
        try {
            if (!((Boolean)preferenceConfiguration.useGriffin.getValueOrDefault()).booleanValue()) {
                preferenceConfiguration.useGriffin.setValue(true);
            }
        }
        finally {
            preferenceConfiguration.dispose();
        }
    }

    public JRebelClientSettings.AgentSelection getAgentSelection() {
        PreferenceConfiguration preferenceConfiguration = new PreferenceConfiguration();
        try {
            if (((Boolean)preferenceConfiguration.useGriffin.getValueOrDefault()).booleanValue()) {
                JRebelClientSettings.AgentSelection agentSelection = JRebelClientSettings.AgentSelection.GRIFFIN;
                return agentSelection;
            }
            JRebelClientSettings.AgentSelection agentSelection = JRebelClientSettings.AgentSelection.EXTERNAL;
            return agentSelection;
        }
        finally {
            preferenceConfiguration.dispose();
        }
    }

    public String getExternalAgentPath() {
        return ExternalJRebel.getPathFromPrefs();
    }

    @NotNull
    public JRebelClientSettings.SyncOnBuildState isRemoteSyncOnBuild() {
        return PreferenceReader.isSyncOnBuildGlobal() ? JRebelClientSettings.SyncOnBuildState.ENABLED : JRebelClientSettings.SyncOnBuildState.DISABLED;
    }

    public Map<String, Object> getMetricsProperties() {
        Map props = super.getMetricsProperties();
        props.put("ide.workspace.hash", EclipseMetricsUtil.getWorkspaceLocationHash());
        props.putAll(this.getPluginVersions());
        props.put("ide.rebel-xml.custom-location", this.isUsingCustomRebelXmlLocation());
        props.put("ide.rebel-xml.custom-location-examples", this.getCustomRebelXmlLocationExamples(5));
        props.putAll(SharedRebelXmlGenerationMetrics.getAdditionalMetrics());
        props.putAll(RebelXmlGenerationMetrics.getAvailableProjectCounts());
        props.putAll(AutoEnableNatureMetrics.getStatsEventMetrics());
        return props;
    }

    private Map<String, String> getPluginVersions() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ide.eclipse.plugin.jr-jee", this.getFeatureVersion("org.zeroturnaround.eclipse.wtp.feature"));
        map.put("ide.eclipse.plugin.jr-maven", this.getFeatureVersion("org.zeroturnaround.eclipse.m2e.feature"));
        map.put("ide.plugins.maven", this.getFeatureVersion("org.eclipse.m2e.feature"));
        map.put("ide.plugins.gradle", this.getFeatureVersion("org.eclipse.buildship"));
        map.put("ide.eclipse.plugin.jst", this.getFeatureVersion("org.eclipse.jst.enterprise_ui.feature"));
        return map;
    }

    private String getFeatureVersion(String featureId) {
        return PlatformInfo.getFeatureVersion(featureId, "none");
    }

    private boolean isUsingCustomRebelXmlLocation() {
        for (JRebelProject project : ProjectModel.getJRebelProjects()) {
            Boolean isUsingCustomLocation = (Boolean)project.hasCustomXmlDirectory().get(project.getProject());
            if (!isUsingCustomLocation.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private List<String> getCustomRebelXmlLocationExamples(int number) {
        ArrayList<String> res = new ArrayList<String>();
        for (JRebelProject project : ProjectModel.getJRebelProjects()) {
            Boolean isUsingCustomLocation = (Boolean)project.hasCustomXmlDirectory().get(project.getProject());
            if (!isUsingCustomLocation.booleanValue()) continue;
            res.add((String)project.customXmlDirectoryPath().get(project.getProject()));
            if (res.size() >= number) break;
        }
        return res;
    }
}

