/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.ExternalJRebel;
import org.zeroturnaround.eclipse.jrebel.RebelAgent;
import org.zeroturnaround.eclipse.jrebel.extension.Agents;
import org.zeroturnaround.jrebel.client.JRebelJar;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class JRebel
extends org.zeroturnaround.jrebel.client.JRebel
implements RebelAgent {
    public static final String JREBEL_JAR = "jrebel.jar";
    private static final Log log = Log.getInstance(JRebel.class);

    protected JRebel(File jrebelJar) {
        super(jrebelJar);
    }

    private static boolean isGriffinAgentSelected() {
        return RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebelBeta6");
    }

    public static boolean isExternalAgentSelected() {
        return !JRebel.isGriffinAgentSelected();
    }

    public static boolean isConfigured() {
        return !JRebel.isExternalAgentSelected() || ExternalJRebel.isInstalled();
    }

    public static JRebel getDefault() {
        if (JRebel.isGriffinAgentSelected()) {
            return JRebel.getGriffinAgent();
        }
        try {
            return JRebel.getExternal();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return JRebel.getGriffinAgent();
        }
    }

    public static JRebel getAdaptedDefault() {
        JRebel processedFile;
        JRebel original = JRebel.getDefault();
        try {
            processedFile = new JRebel(JRebelJar.preprocessAgent((File)original.getJarFile(), (boolean)true)){};
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't preprocess JRebel agent", ex);
        }
        log.info("Adapted jrebel.jar agent path is '{}'", (Object)processedFile.getJarFile().getAbsolutePath());
        return processedFile;
    }

    @NotNull
    public static JRebel getGriffinAgent() {
        return Agents.getFirstJRebelAgent();
    }

    public static JRebel getExternal() {
        return new ExternalJRebel();
    }
}

