/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel;

import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class PlatformInfo {
    public static final String PLUGIN_ID = "org.zeroturnaround.eclipse.feature";
    private static final Log log = Log.getInstance(PlatformInfo.class);
    private static boolean versionInfoLogged = false;

    public static String getProductName() {
        try {
            String name = Platform.getProduct().getName();
            if (name != null) {
                return name;
            }
        }
        catch (Exception exception) {}
        return "nullproduct";
    }

    public static String getProductNameArgValue() {
        return PlatformInfo.getProductName().replace(' ', '_');
    }

    public static String getVersion() {
        try {
            PlatformInfo.logVersionInfo();
            String fullVersion = null;
            String productName = PlatformInfo.getProductName();
            if ("Eclipse".equals(productName) || "Eclipse Platform".equals(productName)) {
                fullVersion = PlatformInfo.getPlatformVersion();
            }
            if (fullVersion == null || fullVersion.length() == 0 || fullVersion.indexOf(46) == -1) {
                Dictionary headers = Platform.getProduct().getDefiningBundle().getHeaders();
                fullVersion = (String)headers.get("Bundle-Version");
            }
            if (fullVersion.lastIndexOf(46) > 0) {
                fullVersion = fullVersion.substring(0, fullVersion.lastIndexOf(46));
            }
            return fullVersion;
        }
        catch (Exception exception) {
            return "0.0.0";
        }
    }

    public static String getPlatformVersion() {
        return PlatformInfo.getFeatureVersion("org.eclipse.platform");
    }

    private static void logVersionInfo() {
        if (versionInfoLogged) {
            return;
        }
        try {
            try {
                log.info("****** Platform version data ******");
                log.info("eclipse.buildId: {}", (Object)System.getProperty("eclipse.buildId"));
                Plugin pl = Platform.getPlugin((String)"org.eclipse.platform");
                log.info("plugin: {}", (Object)pl);
                if (pl != null) {
                    log.info("org.eclipse.platform plugin Version: {}", (Object)pl.getBundle().getVersion());
                }
                Bundle definingBundle = Platform.getProduct().getDefiningBundle();
                log.info("definingBundle: {}", (Object)definingBundle);
                if (definingBundle != null) {
                    log.info("DefiningBundle: {}", (Object)definingBundle.getVersion());
                }
                Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
                log.info("bundle: {}", (Object)bundle);
                if (bundle != null) {
                    log.info("org.eclipse.platform bundle: {}", (Object)bundle.getVersion());
                }
                log.info("feature version: {}", (Object)PlatformInfo.getFeatureVersion("org.eclipse.platform"));
                log.info("product name: {}", (Object)PlatformInfo.getProductName());
                log.info("workspace path: {}", (Object)EclipseUtil.getWorkspaceRoot());
                log.info("****** Platform version data ******");
                log.debug("Java system properties: \n{}", (Object)PlatformInfo.getSystemProperties());
                log.debug("Eclipse bundles: \n{}", (Object)PlatformInfo.getEclipseBundles());
            }
            catch (Exception e) {
                log.warn("Unable to print version info", (Throwable)e);
                versionInfoLogged = true;
            }
        }
        finally {
            versionInfoLogged = true;
        }
    }

    private static String getSystemProperties() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> e : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            sb.append(e.getKey()).append("=").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    private static String getEclipseBundles() {
        StringBuilder sb = new StringBuilder();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            sb.append("Provider: ").append(provider.getName()).append("\n");
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup group = iBundleGroupArray[n4];
                sb.append("  Group: ").append(group.getIdentifier()).append(", version: ").append(group.getVersion()).append(", name: ").append(group.getName()).append("\n");
                Bundle[] bundleArray = group.getBundles();
                int n5 = bundleArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Bundle bundle = bundleArray[n6];
                    sb.append("    Bundle: ").append(bundle.getSymbolicName()).append(", version: ").append(bundle.getVersion()).append(", state: ").append(bundle.getState()).append("\n");
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String getFeatureVersion(String featureID, String defaultValue) {
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = iBundleGroupProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup group = iBundleGroupArray[n4];
                if (featureID.equals(group.getIdentifier())) {
                    return group.getVersion();
                }
                ++n4;
            }
            ++n2;
        }
        return defaultValue;
    }

    public static String getFeatureVersion(String featureID) {
        return PlatformInfo.getFeatureVersion(featureID, "unknown");
    }

    public static boolean hasBundle(String id) {
        return Platform.getBundle((String)id) != null;
    }

    public static String getJRebelPluginVersion() {
        String version = PlatformInfo.getFeatureVersion(PLUGIN_ID, null);
        if (version != null) {
            return version;
        }
        Bundle bundle = Platform.getBundle((String)"org.zeroturnaround.eclipse");
        return bundle.getVersion().toString();
    }

    public static String getJRebelPluginNumericVersion() {
        String pluginVersion = PlatformInfo.getJRebelPluginVersion();
        pluginVersion = pluginVersion.substring(0, pluginVersion.lastIndexOf(46));
        pluginVersion = pluginVersion.replace(".", "");
        StringBuilder sb = new StringBuilder(pluginVersion.length());
        int i = 0;
        while (i < pluginVersion.length()) {
            char c = pluginVersion.charAt(i);
            if (c >= '0' && c <= '9') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getTrimmedJRebelPluginVersionForRelease() {
        return PlatformInfo.normalizeVersion(PlatformInfo.getJRebelPluginVersion());
    }

    public static String normalizeVersion(String version) {
        version = version.replace(".RELEASE", "");
        version = version.replace(".qualifier", "");
        version = version.replaceAll(".PREVIEW.*", "-SNAPSHOT");
        return version;
    }
}

