/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel;

import com.zeroturnaround.jrebel.configuration.ProjectIdsExtractor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.config.model.ProjectModel;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.args.LaunchingArgs;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ProjectsPathProvider
implements LaunchingArgs.DefaultProjectPathsProvider {
    private static final Log log = Log.getInstance(ProjectsPathProvider.class);

    @NotNull
    public Map<String, File> getProjects() {
        log.trace("getProjects");
        long start = System.currentTimeMillis();
        HashMap<String, File> result = new HashMap<String, File>();
        for (JRebelProject project : ProjectModel.getJRebelProjects()) {
            result.putAll(this.getForSingleProject(project.getProject()));
        }
        log.info("Collecting project paths took {} seconds, {} projects ids collected", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start), (Object)result.size());
        return result;
    }

    @NotNull
    public Map<String, File> getForSingleProject(IProject project) {
        HashMap<String, File> result = new HashMap<String, File>();
        IFile rebelXml = ProjectHelper.getRebelXml(project.getProject());
        if (rebelXml != null) {
            File moduleRoot = this.findModuleRoot(project.getProject());
            IPath rebelXmlFullPath = rebelXml.getFullPath();
            for (String projectId : this.getProjectIdsFromRebelXml(rebelXml)) {
                log.debug("Found '{}' projectId in {}, map to project root {}", new Object[]{projectId, rebelXmlFullPath, moduleRoot});
                result.put(projectId, moduleRoot);
            }
        }
        return result;
    }

    private File findModuleRoot(IProject project) {
        return project.getLocation().toFile().getAbsoluteFile();
    }

    private Collection<String> getProjectIdsFromRebelXml(IFile rebelXml) {
        try {
            String contents = FileUtils.readFileToString((File)rebelXml.getLocation().toFile());
            return new ProjectIdsExtractor(contents).getProjectIds();
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return Collections.emptyList();
        }
    }
}

