/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.args;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.IVMInstall;
import org.zeroturnaround.common.args.ArgOpaque;
import org.zeroturnaround.common.args.ArgRegex;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.launching.support.JVMHelper;

public class DynamicRebelArgs {
    public static final ArgRegex ANY_REBEL_ARGS = new ArgRegex("\\$\\{jrebel_args(?:\\.unquoted)?(?:\\.padded)?(?:\\:(.*?))?\\}.*");
    public static final ArgRegex UNQUOTED_REBEL_ARGS = new ArgRegex("\\$\\{jrebel_args \\.unquoted(?:\\:(.*?))?\\}");
    public static final ArgRegex PADDED_REBEL_ARGS = new ArgRegex("\\$\\{jrebel_args\\.padded(?:\\:(.*?))?\\}");
    public static final ArgRegex ANY_XREBEL_ARGS = new ArgRegex("\\$\\{jrebel_xr_args(?:\\.unquoted)?(?:\\.padded)?(?:\\:(.*?))?\\}.*");
    public static final ArgRegex UNQUOTED_XREBEL_ARGS = new ArgRegex("\\$\\{jrebel_xr_args \\.unquoted(?:\\:(.*?))?\\}");
    public static final ArgRegex PADDED_XREBEL_ARGS = new ArgRegex("\\$\\{jrebel_xr_args\\.padded(?:\\:(.*?))?\\}");

    public static ArgOpaque dynamicJRebelArgs(JavaVM jvm, String jrePath, boolean useUnQuotedPaths, boolean usePaddedArgs) throws CoreException {
        return DynamicRebelArgs.dynamicRebelArgs(jvm, jrePath, useUnQuotedPaths, usePaddedArgs, "jrebel_args", "jrebel_args.padded", "jrebel_args.unquoted");
    }

    public static ArgOpaque dynamicXRebelArgs(JavaVM jvm, String jrePath, boolean useUnQuotedPaths, boolean usePaddedArgs) throws CoreException {
        return DynamicRebelArgs.dynamicRebelArgs(jvm, jrePath, useUnQuotedPaths, usePaddedArgs, "jrebel_xr_args", "jrebel_xr_args.padded", "jrebel_xr_args.unquoted");
    }

    private static ArgOpaque dynamicRebelArgs(JavaVM jvm, String jrePath, boolean useUnQuotedPaths, boolean usePaddedArgs, String argsName, String paddedArgsName, String unquotedArgsName) throws CoreException {
        String variableName = usePaddedArgs ? paddedArgsName : (useUnQuotedPaths ? unquotedArgsName : argsName);
        IVMInstall vmInstall = JVMHelper.getVMInstall(jvm);
        if (vmInstall != null) {
            String jrePath2;
            if (!JVMHelper.isDefault(vmInstall) && (jrePath2 = JVMHelper.getJREContainerPathAbbreviated(jrePath, vmInstall)) != null) {
                return new ArgOpaque("${" + variableName + ":" + jrePath2 + "}");
            }
        } else if (jvm.getJavaHome() != null) {
            return new ArgOpaque("${" + variableName + ":JAVA_HOME=" + jvm.getJavaHome().getAbsolutePath() + "}");
        }
        return new ArgOpaque("${" + variableName + "}");
    }
}

