/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.args;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.EclipseJRebelClientAdapter;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.ProjectsPathProvider;
import org.zeroturnaround.eclipse.jrebel.XRebel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.args.LaunchingArgs;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;
import org.zeroturnaround.jrebel.ide.common.http.server.IDEPluginHttpServerHolder;

public class EclipseLaunchingArgs {
    private static final Log log = Log.getInstance(EclipseLaunchingArgs.class);

    public static ArgChanges getJVMArgRemovals() {
        log.trace("getJVMArgRemovals");
        LaunchingArgs launchingArgs = new LaunchingArgs(JRebel::getDefault);
        ArgChanges changes = launchingArgs.getUndoInstallationArgs();
        changes.remove((IArgument)RebelArgs.rebelWorkspacePath((File)EclipseUtil.getWorkspaceRoot()));
        for (IArgument arg : launchingArgs.getEnvironmentArgs().all()) {
            changes.remove(arg);
        }
        return changes;
    }

    public static ArgChanges getXRebelJVMArgAdditions() throws CoreException {
        try {
            return new LaunchingArgs(null, XRebel::getDefault, (LaunchingArgs.DefaultProjectPathsProvider)new ProjectsPathProvider()).getInstallationArgs(null, ProgressMonitor.NONE);
        }
        catch (Exception e) {
            throw new CoreException(RebelPlugin.newErrorStatus(e.getMessage(), e));
        }
    }

    public static ArgChanges getJVMArgAdditions(JavaVM vm, IProgressMonitor monitor) throws CoreException {
        log.trace("getJVMArgAdditions 01");
        return EclipseLaunchingArgs.getJVMArgAdditions(JRebel::getDefault, vm, monitor);
    }

    public static ArgChanges getJVMArgAdditions(LaunchingArgs.JRebelProvider provider, JavaVM vm, IProgressMonitor monitor) throws CoreException {
        try {
            log.trace("getJVMArgAdditions 02");
            LaunchingArgs launchingArgs = new LaunchingArgs(provider, (LaunchingArgs.DefaultProjectPathsProvider)new ProjectsPathProvider());
            ArgChanges changes = launchingArgs.getInstallationArgs(vm, EclipseJRebelClientAdapter.wrapMonitor(monitor));
            JRebelConfiguration config = JRebelConfiguration.getDefault();
            changes.add((IArgument)RebelArgs.configFile((JRebelConfiguration)config));
            if (!config.getConfigurationFile().exists()) {
                changes.add((IArgument)RebelArgs.logFile((JRebelConfiguration)config));
            }
            log.trace("getJVMArgAdditions 03");
            log.trace("ws root {}", (Object)EclipseUtil.getWorkspaceRoot());
            changes.add((IArgument)RebelArgs.rebelWorkspacePath((File)EclipseUtil.getWorkspaceRoot()));
            String notificationUrl = IDEPluginHttpServerHolder.getInstance().getNotificationUrl();
            if (notificationUrl != null) {
                changes.add((IArgument)RebelArgs.notificationUrl((String)notificationUrl));
            }
            changes.merge(launchingArgs.getEnvironmentArgs());
            changes.merge(launchingArgs.getRebelProjectPathArgs());
            log.trace("getJVMArgAdditions 04");
            return changes;
        }
        catch (Exception e) {
            log.trace("getJVMArgAdditions 05 " + e.toString());
            throw new CoreException(RebelPlugin.newErrorStatus(e.getMessage(), e));
        }
    }
}

