/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.args;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.CompositeArgStore;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.args.store.StringArgStore;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class LaunchConfigArgStore
extends CompositeArgStore<String>
implements ITransientArgStore<ILaunchConfigurationWorkingCopy> {
    protected final ILaunchConfiguration config;
    protected ILaunchConfigurationWorkingCopy wc;
    private static final Log log = Log.getInstance(LaunchConfigArgStore.class);

    public LaunchConfigArgStore(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy wc) throws CoreException {
        this(config, wc, ArgFormatter.QUOTED, false);
    }

    public LaunchConfigArgStore(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy wc, ArgFormatter formatter, boolean propertySupport) throws CoreException {
        super(null);
        this.config = config;
        this.wc = wc;
        this.original = new StringArgStore(this.readVMArgs(), formatter, propertySupport);
    }

    public void setWorkingCopy(ILaunchConfigurationWorkingCopy wc) {
        this.wc = wc;
    }

    public abstract String readVMArgs() throws CoreException;

    public abstract void writeVMArgs(String var1) throws CoreException;

    public ILaunchConfigurationWorkingCopy preview(ArgChanges changes) {
        String newArgs = (String)this.original.preview(changes);
        if (!newArgs.equals(((StringArgStore)this.original).original())) {
            try {
                if (this.wc == null) {
                    this.wc = this.config.getWorkingCopy();
                }
                this.writeVMArgs(newArgs);
                return this.wc;
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static LaunchConfigArgStore forAttrVMArguments(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy wc, ArgFormatter formatter, boolean propertySupport) throws CoreException {
        return new LaunchConfigArgStore(config, wc, formatter, propertySupport){

            @Override
            public String readVMArgs() throws CoreException {
                String value = this.config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
                return value != null ? value : "";
            }

            @Override
            public void writeVMArgs(String newArgs) throws CoreException {
                this.wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, newArgs);
            }
        };
    }

    public static LaunchConfigArgStore forEnvVar(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy wc, final String envVarName, ArgFormatter formatter, boolean propertySupport) throws CoreException {
        return new LaunchConfigArgStore(config, wc, formatter, propertySupport){

            @Override
            public String readVMArgs() throws CoreException {
                Map environmentVars = this.config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
                String value = (String)environmentVars.get(envVarName);
                return value != null ? value : "";
            }

            @Override
            public void writeVMArgs(String newArgs) throws CoreException {
                Map environmentVars = this.wc.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
                if (newArgs == null || newArgs.length() == 0) {
                    environmentVars.remove(envVarName);
                } else {
                    environmentVars.put(envVarName, newArgs);
                }
                this.wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environmentVars);
            }
        };
    }

    public static IPersistentArgStore persistent(ITransientArgStore<ILaunchConfigurationWorkingCopy> original) {
        return new PersitentLaunchConfigArgStore(original);
    }

    public static ITransientArgStore<ILaunchConfigurationWorkingCopy> fake(IArgStore original, ILaunchConfigurationWorkingCopy wc) {
        return new FakeLaunchConfigArgStore(LaunchConfigArgStore.toPersistent(original), wc);
    }

    private static IPersistentArgStore toPersistent(IArgStore argStore) {
        if (argStore instanceof IPersistentArgStore) {
            return (IPersistentArgStore)argStore;
        }
        if (argStore instanceof ITransientArgStore) {
            ITransientArgStore transientStore = (ITransientArgStore)argStore;
            return LaunchConfigArgStore.persistent((ITransientArgStore<ILaunchConfigurationWorkingCopy>)transientStore);
        }
        throw new IllegalStateException("Unknown store type: " + argStore);
    }

    private static class FakeLaunchConfigArgStore
    implements ITransientArgStore<ILaunchConfigurationWorkingCopy>,
    IPersistentArgStore {
        private final IPersistentArgStore original;
        private final ILaunchConfigurationWorkingCopy wc;

        private FakeLaunchConfigArgStore(IPersistentArgStore original, ILaunchConfigurationWorkingCopy wc) {
            this.original = original;
            this.wc = wc;
            if (this.original == null) {
                log.info("Error: FakeLaunchConfigArgStore. original: " + original + " wc: " + wc);
            }
        }

        public void apply(ArgChanges changes) {
            this.original.apply(changes);
        }

        public ILaunchConfigurationWorkingCopy preview(ArgChanges changes) {
            this.original.apply(changes);
            return this.wc;
        }

        public boolean contains(IArgument arg) {
            return this.original.contains(arg);
        }

        public List<IArgument> findAll(IArgument arg) {
            return this.original.findAll(arg);
        }

        public Maybe<IArgument> findFirst(IArgument arg) {
            return this.original.findFirst(arg);
        }
    }

    private static class PersitentLaunchConfigArgStore
    extends CompositeArgStore<ILaunchConfigurationWorkingCopy>
    implements IPersistentArgStore {
        private PersitentLaunchConfigArgStore(ITransientArgStore<ILaunchConfigurationWorkingCopy> original) {
            super(original);
        }

        public void apply(ArgChanges changes) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)this.original.preview(changes);
            if (wc != null) {
                try {
                    wc.doSave();
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

