/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.config;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;

public class ConfigurationSaveQueue {
    private static volatile boolean saveScheduled = false;

    public static void save(JRebelConfiguration configuration) {
        if (saveScheduled) {
            return;
        }
        saveScheduled = true;
        new JRebelConfigurationSaveJob(configuration).schedule(500L);
    }

    public static void waitForSave() {
        while (saveScheduled) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static final class JRebelConfigurationSaveJob
    extends Job {
        private final JRebelConfiguration configuration;

        public JRebelConfigurationSaveJob(JRebelConfiguration configuration) {
            super("Saving JRebel Configuration");
            this.configuration = configuration;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Saving properties to file", -1);
            saveScheduled = false;
            this.configuration.save();
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

