/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeroturnaround.eclipse.jrebel.events.JRebelEnablementChangedEvent;
import org.zeroturnaround.eclipse.jrebel.events.JRebelService;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeListener;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelServiceImpl
implements JRebelService {
    private static final Log log = Log.getInstance(JRebelServiceImpl.class);
    private List<JRebelServiceChangeListener> listeners = new CopyOnWriteArrayList<JRebelServiceChangeListener>();

    @Override
    public void addListener(JRebelServiceChangeListener listener) {
        log.trace("addListener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(JRebelServiceChangeListener listener) {
        log.trace("removeListener");
        this.listeners.remove(listener);
    }

    @Override
    public void fireRebelEnablementChangedEvent(Object source, Object launchable, boolean enablement) {
        log.trace("fireRebelEnablementChangedEvent");
        for (JRebelServiceChangeListener listener : this.listeners) {
            listener.rebelEnabledChanged(new JRebelEnablementChangedEvent(source, launchable, enablement));
        }
    }

    @Override
    public void fireStartupConfigurationChangedEvent() {
        log.trace("fireStartupConfigurationChangedEvent");
        for (JRebelServiceChangeListener listener : this.listeners) {
            listener.startupConfigurationChangedEvent();
        }
    }
}

