/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.extension;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.extension.IAgentProvider;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class AgentProvider
implements IExecutableExtension,
IExecutableExtensionFactory,
IAgentProvider {
    private static final Log log = Log.getInstance(AgentProvider.class);
    protected File resolvedLocation;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String bundleId = config.getDeclaringExtension().getContributor().getName();
        String location = config.getAttribute("location");
        this.resolvedLocation = this.resolveLocation(bundleId, location);
    }

    protected abstract String getAgentJarName();

    private File resolveLocation(String bundleId, String path) {
        ServiceReference ref;
        BundleContext bundleContext = RebelPlugin.getDefault().getBundle().getBundleContext();
        PackageAdmin admin = (PackageAdmin)bundleContext.getService(ref = bundleContext.getServiceReference(PackageAdmin.class.getName()));
        Bundle[] bundles = admin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundles[0]);
                return bundleFile != null ? new File(new File(bundleFile, path), this.getAgentJarName()) : null;
            }
            catch (IOException e) {
                log.error("Error locating Embedded Agent", (Throwable)e);
                return null;
            }
        }
        log.error("Error locating Embedded Agent: bundle 'org.zeroturnaround.eclipse.embedder' not found.");
        return null;
    }

    public Object create() throws CoreException {
        return this.getAgent();
    }
}

