/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.extension;

import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.RebelAgent;
import org.zeroturnaround.eclipse.jrebel.XRebel;

public class Agents {
    private static final String EXTENSION_ID = "org.zeroturnaround.eclipse.jrebel.agents";
    private static List<RebelAgent> agentCache = new ArrayList<RebelAgent>();

    public static synchronized List<RebelAgent> getAgents() {
        if (agentCache.isEmpty()) {
            agentCache = Hooks.getHookList(RebelAgent.class, EXTENSION_ID);
        }
        return agentCache;
    }

    public static synchronized JRebel getFirstJRebelAgent() {
        for (RebelAgent agent : Agents.getAgents()) {
            if (!(agent instanceof JRebel)) continue;
            return (JRebel)agent;
        }
        throw new RuntimeException("Couldn't find embedded JRebel agent");
    }

    public static synchronized XRebel getFirstXRebelAgent() {
        for (RebelAgent agent : Agents.getAgents()) {
            if (!(agent instanceof XRebel)) continue;
            return (XRebel)agent;
        }
        throw new RuntimeException("Couldn't find embedded XRebel agent");
    }

    public static synchronized void setAgents(List<RebelAgent> agentCache) {
        Agents.agentCache = agentCache;
    }
}

