/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.zeroturnaround.jrebel.client.logger.Log;

public class FileHashCache {
    private static final Log log = Log.getInstance(FileHashCache.class);
    public static final QualifiedName QN_HASHCACHE = new QualifiedName("org.zeroturnaround.eclipse.remoting", "fileHashCache");

    public static Map<String, String> getProjectCache(IProject project) {
        try {
            HashMap<String, String> cache = (HashMap<String, String>)project.getSessionProperty(QN_HASHCACHE);
            if (cache == null) {
                cache = new HashMap<String, String>();
                FileHashCache.setProjectCache(project, cache);
            }
            return cache;
        }
        catch (Exception exception) {
            return new WeakHashMap<String, String>();
        }
    }

    public static void setProjectCache(IProject project, Map<String, String> cache) {
        try {
            project.setSessionProperty(QN_HASHCACHE, cache);
        }
        catch (CoreException e) {
            log.error("Failed to set up project hash cache", (Throwable)e);
        }
    }

    public static void clearProjectCache(IProject project) {
        try {
            project.setSessionProperty(QN_HASHCACHE, null);
        }
        catch (CoreException e) {
            log.error("Failed to clear project hash cache", (Throwable)e);
        }
    }
}

