/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IObjectActionDelegate;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.jrebel.remoting.actions.RemotingXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.actions.SyncNowAction;
import org.zeroturnaround.eclipse.jrebel.remoting.actions.ToggleRemotingNatureAction;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.EclipseFileEventProcessorManager;
import org.zeroturnaround.eclipse.nature.IRebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.IRemotingProject;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.ProjectNatureUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;
import org.zeroturnaround.jrebel.ide.common.utils.RebelConfBackupUtil;

public class RebelRemotingProvider
implements IRebelRemotingProvider {
    private static final Log log = Log.getInstance(RebelRemotingProvider.class);
    private IRebelRemotingProvider.SaveListener remotingGenerationListener;

    @Override
    public BaseRemoteModule getRemotingClientProject(IProject project) {
        return new RemotingProject(project);
    }

    public URL getRemoteUrl(IProject project) {
        try {
            return new RemotingProject(project).getRemoteUrl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URL[] getRemoteUrls(IProject project) {
        try {
            return new RemotingProject(project).getRemoteUrls();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public void setRemotingGenerationListener(IRebelRemotingProvider.SaveListener remotingGenerationListener) {
        this.remotingGenerationListener = remotingGenerationListener;
    }

    @Override
    public IObjectActionDelegate[] getProjectMenuItemDelegates() {
        return new IObjectActionDelegate[]{new ToggleRemotingNatureAction(), new SyncNowAction()};
    }

    public static RemotingProject getRemotingProject(IProject project) throws CoreException {
        return project.isOpen() ? (RemotingProject)project.getNature("org.zeroturnaround.eclipse.remoting.remotingNature") : null;
    }

    @Override
    public boolean isRemotingProject(IProject project) {
        block7: {
            if (!project.isOpen() || !ProjectHelper.isJRebelProject(project)) {
                return false;
            }
            if (!ProjectHelper.isEligibleForJRebel(project)) {
                return false;
            }
            RemotingProject remotingProject = new RemotingProject(project);
            if (remotingProject.isRemotingDisabled()) {
                return false;
            }
            if (!ProjectHelper.hasNature(project, "org.zeroturnaround.eclipse.remoting.remotingNature")) break block7;
            return true;
        }
        try {
            if (RebelRemotingProvider.isAutoAddJRebelNature() && ProjectHelper.hasRebelRemoteXml(project)) {
                ProjectNatureUtil.addNatureTo(project, null, "org.zeroturnaround.eclipse.remoting.remotingNature");
                return RebelRemotingProvider.getRemotingProject(project) != null;
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
        return false;
    }

    @Override
    public void updateRemotingEnablement(IProject project, RemoteServerConfigurations.ServerSelection serverSelection, IProgressMonitor monitor) throws CoreException {
        IdeRemoting.getInstance().getConfigurations().setServerSelection(this.getRemotingClientProject(project).getIdeModule(), serverSelection);
        this.updateRemotingEnablementInternal(project, !serverSelection.equals((Object)RemoteServerConfigurations.ServerSelection.OFF), monitor, true);
    }

    @Override
    public void updateRemotingEnablement(IProject project, boolean enabled) {
        this.updateRemotingWithServerSelection(project, enabled, (IProgressMonitor)new NullProgressMonitor(), false);
    }

    @Override
    public void updateRemotingEnablement(IProject project, boolean enabled, IProgressMonitor monitor) {
        this.updateRemotingWithServerSelection(project, enabled, monitor, false);
    }

    private void updateRemotingWithServerSelection(IProject project, boolean enabled, IProgressMonitor monitor, boolean showNotification) {
        IdeModule ideModule = this.getRemotingClientProject(project).getIdeModule();
        IdeRemoting.getInstance().getConfigurations().setServerSelectionEnabled(ideModule, enabled);
        try {
            this.updateRemotingEnablementInternal(project, enabled, monitor, showNotification);
        }
        catch (CoreException e) {
            throw new IllegalStateException("Remoting state change failed: " + project, e);
        }
    }

    private void updateRemotingEnablementInternal(IProject project, boolean enabled, IProgressMonitor monitor, boolean showNotification) throws CoreException {
        log.info("updateRemotingEnablement for project {}, hasRemotingNature={}, enable={}, showNotification={}", new Object[]{project.getName(), project.hasNature("org.zeroturnaround.eclipse.remoting.remotingNature"), enabled, showNotification});
        if (enabled) {
            RemotingProject remotingProject = new RemotingProject(project);
            if (!ProjectHelper.hasRebelRemoteXml(project)) {
                this.generateRemoteXml(project, monitor);
            }
            remotingProject.setRemotingDisabled(false);
            if (!project.hasNature("org.zeroturnaround.eclipse.remoting.remotingNature")) {
                ProjectNatureUtil.addNatureTo(project, monitor, "org.zeroturnaround.eclipse.remoting.remotingNature");
                if (showNotification) {
                    IdeRemoting.getInstance().getNotifier().showRemoteServerSupportEnabledNotification(project.getName());
                }
            }
            try {
                project.refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                log.debug("Refresh failed for project: {}, error: {}", (Object)project, (Object)e.getMessage());
            }
            EclipseFileEventProcessorManager.getInstance().createProcessor(project);
        } else {
            EclipseFileEventProcessorManager.getInstance().dispose(project);
            RemotingProject remotingProject = new RemotingProject(project);
            remotingProject.setRemotingDisabled(true);
            project.deleteMarkers("org.zeroturnaround.eclipse.remoting.rebelRemotingProblem", false, 2);
            RebelRemotingProvider.deleteRemoteXml(project);
            if (project.hasNature("org.zeroturnaround.eclipse.remoting.remotingNature")) {
                ProjectNatureUtil.removeNatureFrom(project, monitor, "org.zeroturnaround.eclipse.remoting.remotingNature");
            }
        }
    }

    private void generateRemoteXml(IProject project, IProgressMonitor monitor) {
        this.generateRemoteXml(project, monitor, false);
    }

    @Override
    public void generateRemoteXml(IProject project, IProgressMonitor monitor, boolean forceRegeneration) {
        IContainer folder = this.getRemotingXmlFolder(project);
        if (forceRegeneration || !this.restoreRemoteXml((IContainer)project, folder)) {
            IFile remoteXml = project.getFile(folder.getProjectRelativePath().append("rebel-remote.xml"));
            RemotingXmlGenerator.generate(project, null, remoteXml, monitor, this.remotingGenerationListener);
        }
    }

    private IContainer getRemotingXmlFolder(IProject project) {
        IContainer folder = new JRebelProject(project).getProjectCustomXmlFolder();
        if (folder != null) {
            return folder;
        }
        return new RemotingXmlGenerator(project).findBestSourceFolderForRemotingXml();
    }

    private boolean restoreRemoteXml(IContainer projectRoot, IContainer targetFolder) {
        File root = this.toFile((IResource)projectRoot);
        File targetFile = this.toFile((IResource)targetFolder);
        if (root == null || targetFile == null) {
            log.warn("Unable to restore rebel-remote.xml, missing root: {} ({}) or target: {} ({})", new Object[]{projectRoot, root, targetFolder, targetFile});
            return false;
        }
        File projectRootFile = projectRoot.getLocation().toFile();
        File destinationFolder = targetFolder.getLocation().toFile();
        return RebelConfBackupUtil.restoreFromProject((File)projectRootFile, (File)destinationFolder, (RebelConfBackupUtil.Xml)RebelConfBackupUtil.Xml.REBEL_REMOTE_XML, (RebelConfBackupUtil.Product)RebelConfBackupUtil.Product.ECLIPSE);
    }

    private File toFile(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getLocation();
        if (path == null) {
            return null;
        }
        return path.toFile();
    }

    private static void deleteRemoteXml(IProject project) {
        ProjectHelper.deleteWithBackup(project, ProjectHelper.getRebelRemoteXml(project));
    }

    private static boolean isAutoAddJRebelNature() {
        return RebelPlugin.getDefault().getPreferenceStore().getBoolean("jrebelAutoNature");
    }

    @Override
    public IRemotingProject getProjectAdapter(IProject project) {
        return new RemotingProject(project).setRemotingGeneratorListener(this.remotingGenerationListener);
    }

    @Override
    public void setSaveListener(IRebelRemotingProvider.SaveListener l) {
        this.setRemotingGenerationListener(l);
    }
}

