/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting;

import com.zeroturnaround.jrebel.ide.common.IdeInstance;
import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.ide.common.IdeStorage;
import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.PlatformUI;
import org.zeroturnaround.common.Version;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.jrebel.remoting.PerspectiveListener;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.jrebel.remoting.ResourceChangeListener;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.EclipseFileEventProcessorManager;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.SynchronizationUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class RemotingPluginStartup {
    private static final Log log = Log.getInstance(RemotingPluginStartup.class);

    public static void earlyStartup() {
        log.info("earlyStartup");
        final ResourceChangeListener listener = new ResourceChangeListener();
        EclipseUtil.runInUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveListener());
                    EclipseUtil.getWorkspace().addResourceChangeListener(listener, Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    log.info("failed to add PerspectiveListener: " + e);
                }
            }
        });
        RemotingPluginStartup.migrateProjectsToRemote20();
        RemotingPluginStartup.migrateRemoteInstanceToGlobalConf();
        RemotingPluginStartup.checkIfShouldDisableRemoting();
        RemotingPluginStartup.startUpFsListener();
    }

    private static void checkIfShouldDisableRemoting() {
        RemoteServerConfigurations rsc = IdeRemoting.getInstance().getConfigurations();
        for (IProject project : SynchronizationUtil.getRemotingProjectsList()) {
            EclipseIdeProject module = new EclipseIdeProject(project);
            if (!rsc.shouldDisableRemotingBecauseExplicitServersDeleted((IdeModule)module)) continue;
            rsc.disableRemotingBecauseExplicitServersDeleted((IdeModule)module);
        }
    }

    private static void startUpFsListener() {
        Job job = new Job("Initialize filesystem listener for JRebel Remote projects"){

            protected IStatus run(IProgressMonitor monitor) {
                RemotingPluginStartup.createFsProcessors();
                return Status.OK_STATUS;
            }
        };
        job.schedule(5000L);
    }

    private static void createFsProcessors() {
        try {
            for (IProject project : SynchronizationUtil.getRemotingProjectsList()) {
                EclipseFileEventProcessorManager.getInstance().createProcessor(project);
            }
        }
        catch (Exception e) {
            log.warn("Creating fs processors failed", (Throwable)e);
        }
    }

    private static void migrateProjectsToRemote20() {
        try {
            List<BaseRemoteModule> remotingProjects = SynchronizationUtil.getRemotingProjects();
            for (BaseRemoteModule project : remotingProjects) {
                if (project instanceof RemotingProject) {
                    ((RemotingProject)project).doMigrations();
                    continue;
                }
                log.info("expected RemotingProject class, got " + project.getClass().getName());
            }
        }
        catch (Exception exception) {
            log.error("Failed to migrate projects to support new remote servers");
        }
    }

    private static void migrateRemoteInstanceToGlobalConf() {
        try {
            IdeStorage ideStorage = IdeInstance.getInstance().storage();
            RemoteServerConfigurations remoteConfig = IdeRemoting.getInstance().getConfigurations();
            Version featureVersion = new Version("2019.2.0");
            if (ideStorage.getFormatVersion().isBefore(featureVersion)) {
                log.info("Migrating workspace to global remote server config");
                remoteConfig.migrateInstanceToGlobal();
                ideStorage.setFormatVersion(featureVersion);
            }
            for (BaseRemoteModule module : SynchronizationUtil.getRemotingProjects()) {
                IdeStorage moduleStorage = module.getIdeModule().storage();
                if (!moduleStorage.getFormatVersion().isBefore(featureVersion)) continue;
                log.info("Migrating project '{}' to global remote server config", (Object)module.getName());
                remoteConfig.migrateExplicitInstanceToExplicitGlobal(module.getIdeModule());
                moduleStorage.setFormatVersion(featureVersion);
            }
        }
        catch (Exception e) {
            log.error("Failed to migrate workspace or projects to global remote config storage", (Throwable)e);
        }
    }
}

