/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.BaseRemoteModule;
import com.zeroturnaround.jrebel.remoting.Configuration;
import com.zeroturnaround.jrebel.remoting.FileNavigator;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.configuration.ConfigurationError;
import com.zeroturnaround.jrebel.remoting.configuration.Dir;
import com.zeroturnaround.jrebel.remoting.configuration.builders.ConfigurationBuilder;
import com.zeroturnaround.jrebel.remoting.configuration.builders.source.ConfigurationSource;
import com.zeroturnaround.jrebel.remoting.configuration.builders.source.RebelRemoteXmlSource;
import com.zeroturnaround.jrebel.remoting.configuration.builders.source.RebelXmlSource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.jrebel.remoting.FileHashCache;
import org.zeroturnaround.eclipse.jrebel.remoting.files.EclipseFileNavigator;
import org.zeroturnaround.eclipse.nature.IRebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.IRemotingProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.property.BooleanProjectProperty;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.javarebel.Licensing;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.Watcher;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public final class RemotingProject
extends BaseRemoteModule
implements IProjectNature,
IRemotingProject {
    private static final Log log = Log.getInstance(RemotingProject.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(RemotingProject.class);
    private static final String QN_QUALIFIER = "org.zeroturnaround.eclipse.remoting";
    public static final String NATURE_ID = "org.zeroturnaround.eclipse.remoting.remotingNature";
    public static final String REMOTING_PROBLEM = "org.zeroturnaround.eclipse.remoting.rebelRemotingProblem";
    private static final QualifiedName QN_DEPLOYMENT_IDS = new QualifiedName("org.zeroturnaround.eclipse.remoting", "deploymentIds");
    private static final QualifiedName QN_REMOTING_DISABLED = new QualifiedName("org.zeroturnaround.eclipse.remoting", "remotingDisabled");
    private static final QualifiedName QN_AUTH_USERNAME = new QualifiedName("org.zeroturnaround.eclipse.remoting", "authUsername");
    private static final QualifiedName QN_AUTH_PASSWORD = new QualifiedName("org.zeroturnaround.eclipse.remoting", "authPassword");
    private static final QualifiedName QN_DELETE_MISSING_FILES_ON_SYNC = new QualifiedName("org.zeroturnaround.eclipse.remoting", "deleteMissingFilesOnSync");
    private static final QualifiedName QN_HASHCACHES = new QualifiedName("org.zeroturnaround.eclipse.remoting", "fileHashCaches");
    private static final String KEY_NEW_PROJECT_DELETE_FILES_ON_SYNC_DEFAULT = "rebel.ide.remoting.delete_files_on_sync_default";
    private IProject project;
    private Configuration conf;
    private IRebelRemotingProvider.SaveListener remotingGeneratorListener;

    public RemotingProject() {
        this(null);
    }

    public RemotingProject(@Nullable IProject project) {
        super(IdeRemoting.getInstance(), (IdeModule)new EclipseIdeProject(project));
        if (project != null) {
            this.setProject(project);
        }
    }

    private BooleanProjectProperty deleteMissingFile() {
        return new BooleanProjectProperty(QN_DELETE_MISSING_FILES_ON_SYNC, false);
    }

    public String getName() {
        return this.project == null ? "(unnamed)" : this.project.getName();
    }

    public URL getRemoteUrl() {
        List servers = this.getRemoteServersForSync();
        if (!servers.isEmpty()) {
            try {
                URI url = ((RemoteServerConfiguration)servers.get(0)).getUrl();
                if (url != null) {
                    return url.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.warn("Failed to convert URI: " + ((RemoteServerConfiguration)servers.get(0)).getUrl());
            }
        }
        return null;
    }

    @Override
    public URL[] getRemoteUrls() {
        if (this.project == null) {
            return null;
        }
        ArrayList<URL> serverUrls = new ArrayList<URL>();
        for (RemoteServerConfiguration server : this.getRemoteServersForSync()) {
            try {
                URI uri = server.getUrl();
                if (uri == null) continue;
                serverUrls.add(uri.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                log.error("Invalid remote URL[" + server.getUrl() + "]");
            }
        }
        return serverUrls.isEmpty() ? null : serverUrls.toArray(new URL[serverUrls.size()]);
    }

    @Deprecated
    public void setRemoteUrl(URL remoteUrl) {
    }

    @Override
    @Deprecated
    public void setRemoteUrls(URL[] urls) {
    }

    public Configuration getConf() {
        if (this.conf == null) {
            log.info("Conf is NULL, must do rebuild");
            try {
                this.project.deleteMarkers(REMOTING_PROBLEM, false, 2);
            }
            catch (CoreException coreException) {}
            ConfigurationSource rebelXmlSource = this.getRebelXmlSource();
            ConfigurationSource rebelRemoteXmlSource = this.getRebelRemoteXmlSource();
            try {
                ConfigurationBuilder configurationBuilder = new ConfigurationBuilder(rebelXmlSource, rebelRemoteXmlSource, this.project.getLocation().toFile(), EclipseUtil.getWorkspaceRoot());
                this.conf = configurationBuilder.build();
            }
            catch (ConfigurationError e) {
                log.error((Throwable)e);
                RemotingProject.addError((IResource)this.project, e.getMessage());
            }
        }
        return this.conf;
    }

    @NotNull
    private ConfigurationSource getRebelRemoteXmlSource() {
        IFile rebelRemoteXml = ProjectHelper.getRebelRemoteXml(this.project);
        if (rebelRemoteXml == null) {
            Set<String> paths = ProjectHelper.findClasspathFileFolders(this.project, "rebel-remote.xml", true);
            RemotingProject.addError((IResource)this.project, "Missing rebel-remote.xml, lookup folders: " + paths);
            throw new IllegalStateException("Missing rebel-remote.xml for project " + this.project.getName());
        }
        return new RebelRemoteXmlSource(this.getFile(rebelRemoteXml));
    }

    private File getFile(IFile file) {
        return file.getLocation().toFile().getAbsoluteFile();
    }

    @NotNull
    private ConfigurationSource getRebelXmlSource() {
        if (this.getIdeModule().isIdeRebelXmlGenerationType()) {
            IFile rebelXml = ProjectHelper.getRebelXml(this.project);
            if (rebelXml == null) {
                Set<String> paths = ProjectHelper.findClasspathFileFolders(this.project, "rebel.xml", false);
                RemotingProject.addError((IResource)this.project, "Missing rebel.xml, lookup folders: " + paths);
                throw new IllegalStateException("Missing rebel.xml for project " + this.project.getName());
            }
            return new RebelXmlSource(this.getFile(rebelXml));
        }
        String rebelXmlContent = this.getIdeModule().getSavedRebelXmlContent();
        if (rebelXmlContent == null) {
            throw new IllegalStateException("Saved rebel.xml content is null for project " + this.project.getName());
        }
        return new RebelXmlSource(rebelXmlContent);
    }

    private static void addError(IResource resource, String msg) {
        consoleLog.error("[Project {}] {}", (Object)resource.getName(), (Object)msg);
        RemotingProject.addErrorMarker(resource, msg);
    }

    private static void addErrorMarker(IResource resource, String msg) {
        try {
            IMarker marker = resource.createMarker(REMOTING_PROBLEM);
            marker.setAttribute("message", (Object)msg);
            marker.setAttribute("severity", 2);
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        super.overrideIdeModule((IdeModule)new EclipseIdeProject(project));
        try {
            if (project.getSessionProperty(QN_DEPLOYMENT_IDS) == null) {
                project.setSessionProperty(QN_DEPLOYMENT_IDS, new HashMap());
            }
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
        }
    }

    public String getDeploymentId(URI url) {
        return this.getDeploymentIds().get(url.toString());
    }

    public void setDeploymentId(String id, URI url) {
        this.getDeploymentIds().put(url.toString(), id);
    }

    private Map<String, String> getDeploymentIds() {
        try {
            Map map = (Map)this.project.getSessionProperty(QN_DEPLOYMENT_IDS);
            return map;
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public boolean getDeleteFilesOnSync() {
        return (Boolean)this.deleteMissingFile().get(this.project);
    }

    @Override
    public void setDeleteFilesOnSync(boolean delete) {
        this.deleteMissingFile().set(this.project, delete);
    }

    public Map<String, String> getHashCache(URI url) {
        try {
            String urlString;
            HashMap hashCaches = (HashMap)this.project.getSessionProperty(QN_HASHCACHES);
            if (hashCaches == null) {
                hashCaches = new HashMap();
                this.project.setSessionProperty(QN_HASHCACHES, hashCaches);
            }
            if (!hashCaches.containsKey(urlString = url.toString())) {
                hashCaches.put(urlString, new HashMap());
            }
            return (Map)hashCaches.get(urlString);
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
            return FileHashCache.getProjectCache(this.project);
        }
    }

    public FileNavigator getFileProvider(Dir dir) {
        return new EclipseFileNavigator(this.project, dir);
    }

    @Nullable
    private String getPasswordRemote10() {
        try {
            return this.project.getPersistentProperty(QN_AUTH_PASSWORD);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public boolean isRemotingDisabled() {
        try {
            return "true".equals(this.project.getPersistentProperty(QN_REMOTING_DISABLED));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public void setRemotingDisabled(boolean value) {
        try {
            this.project.setPersistentProperty(QN_REMOTING_DISABLED, value ? "true" : null);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.zeroturnaround.eclipse.remoting.remotingBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.zeroturnaround.eclipse.remoting.remotingBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.zeroturnaround.eclipse.remoting.remotingBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public RemotingProject setRemotingGeneratorListener(IRebelRemotingProvider.SaveListener remotingGeneratorListener) {
        this.remotingGeneratorListener = remotingGeneratorListener;
        return this;
    }

    public Map<String, String> getAdditionalHeaders() {
        Licensing.SDKLicenseInfo info = Watcher.getInstance().getLastLicensingInfo();
        Watcher.getInstance().getLicensing();
        return JRebelLicensing.getAdditionalHeadersForRemotingRequest((Licensing.SDKLicenseInfo)info, (String)"Eclipse");
    }

    public synchronized void doMigrations() {
    }
}

