/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import com.zeroturnaround.jrebel.remoting.RemoteServerConfigurations;
import com.zeroturnaround.jrebel.remoting.fsobserver.FSController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider;
import org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject;
import org.zeroturnaround.eclipse.jrebel.remoting.builder.EclipseFileEventProcessorManager;
import org.zeroturnaround.eclipse.nature.JRebelProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class ResourceChangeListener
implements IResourceChangeListener {
    private static final Log log = Log.getInstance(ResourceChangeListener.class);
    private Map<IFile, Long> resourceFileModificationStamps = new HashMap<IFile, Long>();

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IProject project;
                    IResource resource = delta.getResource();
                    if (1 == resource.getType() && FSController.isConfigurationFile((String)resource.getName()) && ResourceChangeListener.isChangedSourceFile(delta)) {
                        ResourceChangeListener.this.onRemotingConfigurationFileChanged((IFile)resource);
                    }
                    if (resource.getType() == 4 && (ResourceChangeListener.isClosedProject(delta) || ResourceChangeListener.isDeletedProject(delta))) {
                        EclipseFileEventProcessorManager.getInstance().dispose((IProject)resource);
                    }
                    if ((resource.getType() & 4) != 0 && delta.getKind() == 4) {
                        project = (IProject)resource;
                        if (ResourceChangeListener.isOpenedProject(delta)) {
                            ResourceChangeListener.this.projectOpened(project);
                        }
                    }
                    if (delta.getKind() == 1 && resource.getType() == 4) {
                        project = resource.getProject();
                        log.debug("project {} added. is open={}", (Object)project.getName(), (Object)project.isOpen());
                        ProjectHelper.checkNatures(project);
                        if (!ProjectHelper.isEligibleForJRebel(project)) {
                            log.debug("project is not eligible for JRebel");
                            return false;
                        }
                        if (ProjectHelper.hasRebelRemoteXml(project)) {
                            log.debug("added project which has remote.xml {}", (Object)project.getName());
                            if (ProjectHelper.isJRebelRemotingProject(project)) {
                                ResourceChangeListener.this.ensureHasServerSelection(project);
                                ResourceChangeListener.this.projectOpened(project);
                                log.debug("Project is remoting project already");
                                return false;
                            }
                            if (ProjectHelper.isJRebelProject(project)) {
                                log.debug("Project {} is JRebel project, but not remote", (Object)project);
                                return false;
                            }
                            this.tryEnableRemotingOnProject(resource.getProject());
                        }
                    }
                    return true;
                }

                private void tryEnableRemotingOnProject(IProject project) {
                    try {
                        log.debug("Trying to enable remote server support on {}", (Object)project);
                        new RebelRemotingProvider().updateRemotingEnablement(project, true, null);
                        JRebelProject.updateJRebelEnablement(project, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e);
                    }
                }
            });
        }
        catch (CoreException e) {
            log.warn((Throwable)e);
        }
    }

    protected void onRemotingConfigurationFileChanged(IFile resource) {
        log.debug("conf file {} changed for project {}", (Object)resource, (Object)resource.getProject());
        Long modificationStamp = resource.getModificationStamp();
        if (modificationStamp.equals(this.resourceFileModificationStamps.get(resource))) {
            return;
        }
        EclipseFileEventProcessorManager.getInstance().confChangedForProject(resource.getProject());
        this.resourceFileModificationStamps.put(resource, modificationStamp);
    }

    private void projectOpened(IProject project) {
        log.debug("project opened {}", (Object)project.getName());
        if (ProjectHelper.isJRebelRemotingProject(project)) {
            RemotingProject p = new RemotingProject(project);
            p.doMigrations();
            final IdeModule module = p.getIdeModule();
            if (IdeRemoting.getInstance().getConfigurations().shouldDisableRemotingBecauseExplicitServersDeleted(module)) {
                log.debug("Will disable remoting on project {}", (Object)project);
                Job job = new Job("Disabling remote server support on " + project.getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        IdeRemoting.getInstance().getConfigurations().disableRemotingBecauseExplicitServersDeleted(module);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            } else {
                log.debug("Setting up FS listener for {}", (Object)project);
                EclipseFileEventProcessorManager.getInstance().createProcessor(project);
            }
        }
    }

    private void ensureHasServerSelection(IProject project) {
        log.debug("Ensuring that project {} has valid server selection", (Object)project);
        EclipseIdeProject ideModule = new EclipseIdeProject(project);
        RemoteServerConfigurations.ServerSelection serverSelection = IdeRemoting.getInstance().getConfigurations().getServerSelection((IdeModule)ideModule);
        if (RemoteServerConfigurations.ServerSelection.OFF.equals((Object)serverSelection)) {
            log.debug("Server selection was off, setting to workspace servers");
            IdeRemoting.getInstance().getConfigurations().setServerSelection((IdeModule)ideModule, RemoteServerConfigurations.ServerSelection.INSTANCE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isChangedSourceFile(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (delta.getKind() != 4) return false;
        if (delta.getResource().getType() != 1) return false;
        if (delta.getFlags() != 256) {
            return false;
        }
        try {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = EclipseUtil.getJavaProject(resource.getProject());
            if (javaProject == null) return false;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry cp = iClasspathEntryArray[n2];
                if (cp.getEntryKind() == 3 && cp.getPath() != null) {
                    log.trace("resource={} source folder={}", (Object)resource.getFullPath(), (Object)cp.getPath());
                    if (cp.getPath().isPrefixOf(resource.getFullPath())) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static boolean isDeletedProject(IResourceDelta delta) {
        return delta.getKind() == 2;
    }

    private static boolean isClosedProject(IResourceDelta delta) {
        return !delta.getResource().getProject().isOpen() && (delta.getFlags() & 0x4000) != 0;
    }

    private static boolean isOpenedProject(IResourceDelta delta) {
        return delta.getResource().getProject().isOpen() && (delta.getFlags() & 0x4000) != 0;
    }
}

