/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.jrebel.remoting.actions;

import com.zeroturnaround.jrebel.remoting.io.Source;
import com.zeroturnaround.jrebel.remoting.util.RebelRemoteEditor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.nature.IRebelRemotingProvider;
import org.zeroturnaround.eclipse.nature.MyResourceVisitor;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.nature.RemoteModuleName;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RemotingXmlGenerator {
    private static final Log log = Log.getInstance(RemotingXmlGenerator.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(RemotingXmlGenerator.class);
    private final IProject project;

    public RemotingXmlGenerator(IProject project) {
        this.project = project;
    }

    public IContainer findBestSourceFolderForRemotingXml() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            MyResourceVisitor visitor = new MyResourceVisitor("rebel.xml", null, ProjectHelper.DEFAULT_OUT_FOLDERS);
            try {
                this.project.accept((IResourceVisitor)visitor);
                if (visitor.getFoundFile() != null) {
                    return visitor.getFoundFile().getParent();
                }
            }
            catch (CoreException e) {
                log.error("Failed to search existing rebel.xml", (Throwable)e);
            }
            return this.project.getProject();
        }
        try {
            RebelXmlGenerator generator = RebelXmlGenerator.forProject(this.project);
            if (generator != null) {
                return generator.findBestSourceFolderForRebelXml();
            }
        }
        catch (Exception e) {
            consoleLog.warn("Error finding Best Source Folder For Remoting Xml.", (Throwable)e);
        }
        return javaProject.getProject();
    }

    private IJavaProject getJavaProject() {
        return EclipseUtil.getJavaProject(this.project);
    }

    private void saveRebelRemoteXml(byte[] bytes, IFile file, IProgressMonitor monitor, IRebelRemotingProvider.SaveListener listener) throws CoreException {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            file.setContents((InputStream)input, true, true, monitor);
        } else {
            file.create((InputStream)input, true, monitor);
        }
        IPath remoteXmlFullPath = file.getFullPath();
        if (listener != null) {
            listener.onSuccess(remoteXmlFullPath);
        }
    }

    public static void generate(IProject project, Source source, IFile remoteXml, IProgressMonitor monitor, IRebelRemotingProvider.SaveListener remotingGenerationListener) {
        try {
            RemotingXmlGenerator generator = new RemotingXmlGenerator(project);
            RebelRemoteEditor editor = RemotingXmlGenerator.newRebelRemoteEditor(project, source);
            byte[] bytes = editor.generateXml();
            generator.saveRebelRemoteXml(bytes, remoteXml, monitor, remotingGenerationListener);
        }
        catch (Exception e) {
            consoleLog.error("rebel-remote.xml generation failed.", (Throwable)e);
            ConsoleLog.open();
        }
    }

    private static RebelRemoteEditor newRebelRemoteEditor(IProject project, Source nullableSource) throws IOException {
        if (nullableSource != null) {
            return new RebelRemoteEditor(nullableSource);
        }
        return new RebelRemoteEditor(RemoteModuleName.getRemoteId(project));
    }
}

